/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.addSupport;

import com.intellij.diagnostic.PluginException;
import com.intellij.framework.FrameworkOrGroup;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FrameworkSupportInModuleProvider
implements FrameworkOrGroup {
    @NotNull
    public abstract FrameworkTypeEx getFrameworkType();

    @NotNull
    public abstract FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel var1);

    public abstract boolean isEnabledForModuleType(@NotNull ModuleType var1);

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        return this.isEnabledForModuleType(builder.getModuleType());
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        return false;
    }

    public boolean canAddSupport(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        return !this.isSupportAlreadyAdded(module, facetsProvider);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.getFrameworkType().getPresentableName();
    }

    public FrameworkRole[] getRoles() {
        return this.getFrameworkType().getRoles();
    }

    public String getVersionLabel() {
        return "Version:";
    }

    public List<FrameworkDependency> getDependenciesFrameworkIds() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public String getId() {
        return this.getFrameworkType().getId();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.getFrameworkType().getIcon();
        if (icon == null) {
            Class<?> aClass = ((Object)((Object)this.getFrameworkType())).getClass();
            Logger logger = Logger.getInstance(FrameworkSupportInModuleProvider.class);
            PluginException.logPluginError((Logger)logger, (String)("FrameworkType::getIcon returns null for " + aClass), null, aClass);
            return EmptyIcon.ICON_16;
        }
        return icon;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public static class FrameworkDependency {
        private final String myFrameworkId;
        private final boolean myOptional;

        private FrameworkDependency(String frameworkId, boolean optional) {
            this.myFrameworkId = frameworkId;
            this.myOptional = optional;
        }

        public static FrameworkDependency optional(String frameworkId) {
            return new FrameworkDependency(frameworkId, true);
        }

        public static FrameworkDependency required(String frameworkId) {
            return new FrameworkDependency(frameworkId, false);
        }

        public String getFrameworkId() {
            return this.myFrameworkId;
        }

        public boolean isOptional() {
            return this.myOptional;
        }
    }
}

