/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandler;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private final JavaClassFindUsagesOptions myFindClassOptions;
    private final JavaMethodFindUsagesOptions myFindMethodOptions;
    private final JavaPackageFindUsagesOptions myFindPackageOptions;
    private final JavaThrowFindUsagesOptions myFindThrowOptions;
    private final JavaVariableFindUsagesOptions myFindVariableOptions;

    public static JavaFindUsagesHandlerFactory getInstance(@NotNull Project project) {
        return (JavaFindUsagesHandlerFactory)((Object)ContainerUtil.findInstance((Object[])EP_NAME.getExtensions((AreaInstance)project), JavaFindUsagesHandlerFactory.class));
    }

    public JavaFindUsagesHandlerFactory(Project project) {
        this.myFindClassOptions = new JavaClassFindUsagesOptions(project);
        this.myFindMethodOptions = new JavaMethodFindUsagesOptions(project);
        this.myFindPackageOptions = new JavaPackageFindUsagesOptions(project);
        this.myFindThrowOptions = new JavaThrowFindUsagesOptions(project);
        this.myFindVariableOptions = new JavaVariableFindUsagesOptions(project);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        return new JavaFindUsagesProvider().canFindUsagesFor(element);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        if (element instanceof PsiDirectory) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            return psiPackage == null ? null : new JavaFindUsagesHandler((PsiElement)psiPackage, this);
        }
        if (element instanceof PsiMethod && operationMode != FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES) {
            PsiMethod method = (PsiMethod)element;
            PsiMethod[] methods = operationMode == FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS && Registry.is((String)"java.find.usages.always.use.top.hierarchy.methods") ? SuperMethodWarningUtil.getTargetMethodCandidates(method, Collections.emptyList()) : SuperMethodWarningUtil.checkSuperMethods(method, JavaFindUsagesHandler.getActionString());
            if (methods.length > 1) {
                return new JavaFindUsagesHandler(element, (PsiElement[])methods, this);
            }
            if (methods.length == 1) {
                return new JavaFindUsagesHandler((PsiElement)methods[0], this);
            }
            return FindUsagesHandler.NULL_HANDLER;
        }
        return new JavaFindUsagesHandler(element, this);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        return this.createFindUsagesHandler(element, forHighlightUsages ? FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES : FindUsagesHandlerFactory.OperationMode.DEFAULT);
    }

    @NotNull
    public JavaClassFindUsagesOptions getFindClassOptions() {
        return this.myFindClassOptions;
    }

    @NotNull
    public JavaMethodFindUsagesOptions getFindMethodOptions() {
        return this.myFindMethodOptions;
    }

    @NotNull
    public JavaPackageFindUsagesOptions getFindPackageOptions() {
        return this.myFindPackageOptions;
    }

    @NotNull
    public JavaThrowFindUsagesOptions getFindThrowOptions() {
        return this.myFindThrowOptions;
    }

    @NotNull
    public JavaVariableFindUsagesOptions getFindVariableOptions() {
        return this.myFindVariableOptions;
    }
}

