/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaClassFindUsagesOptions
extends JavaFindUsagesOptions {
    public boolean isMethodsUsages;
    public boolean isFieldsUsages;
    public boolean isDerivedClasses;
    public boolean isImplementingClasses;
    public boolean isDerivedInterfaces;
    public boolean isCheckDeepInheritance = true;
    public boolean isIncludeInherited;

    public JavaClassFindUsagesOptions(@NotNull Project project) {
        super(project);
    }

    public JavaClassFindUsagesOptions(@NotNull SearchScope searchScope) {
        super(searchScope);
    }

    @Override
    protected void setDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        super.setDefaults(properties, prefix);
        this.isMethodsUsages = properties.getBoolean(prefix + "isMethodsUsages");
        this.isFieldsUsages = properties.getBoolean(prefix + "isFieldsUsages");
        this.isDerivedClasses = properties.getBoolean(prefix + "isDerivedClasses");
        this.isImplementingClasses = properties.getBoolean(prefix + "isImplementingClasses");
        this.isDerivedInterfaces = properties.getBoolean(prefix + "isDerivedInterfaces");
        this.isCheckDeepInheritance = properties.getBoolean(prefix + "isCheckDeepInheritance", true);
        this.isIncludeInherited = properties.getBoolean(prefix + "isIncludeInherited");
    }

    @Override
    protected void storeDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        super.storeDefaults(properties, prefix);
        properties.setValue(prefix + "isMethodsUsages", this.isMethodsUsages);
        properties.setValue(prefix + "isFieldsUsages", this.isFieldsUsages);
        properties.setValue(prefix + "isDerivedClasses", this.isDerivedClasses);
        properties.setValue(prefix + "isImplementingClasses", this.isImplementingClasses);
        properties.setValue(prefix + "isDerivedInterfaces", this.isDerivedInterfaces);
        properties.setValue(prefix + "isCheckDeepInheritance", this.isCheckDeepInheritance, true);
        properties.setValue(prefix + "isIncludeInherited", this.isIncludeInherited);
    }

    @Override
    protected void addUsageTypes(@NotNull Set<? super String> strings) {
        if (this.isUsages || this.isMethodsUsages || this.isFieldsUsages) {
            strings.add(AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]));
        }
        if (this.isDerivedClasses) {
            strings.add(JavaAnalysisBundle.message((String)"find.usages.panel.title.derived.classes", (Object[])new Object[0]));
        }
        if (this.isImplementingClasses) {
            strings.add(JavaAnalysisBundle.message((String)"find.usages.panel.title.implementing.classes", (Object[])new Object[0]));
        }
        if (this.isDerivedInterfaces) {
            strings.add(JavaAnalysisBundle.message((String)"find.usages.panel.title.derived.interfaces", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaClassFindUsagesOptions that = (JavaClassFindUsagesOptions)((Object)o);
        if (this.isCheckDeepInheritance != that.isCheckDeepInheritance) {
            return false;
        }
        if (this.isDerivedClasses != that.isDerivedClasses) {
            return false;
        }
        if (this.isDerivedInterfaces != that.isDerivedInterfaces) {
            return false;
        }
        if (this.isFieldsUsages != that.isFieldsUsages) {
            return false;
        }
        if (this.isImplementingClasses != that.isImplementingClasses) {
            return false;
        }
        if (this.isIncludeInherited != that.isIncludeInherited) {
            return false;
        }
        return this.isMethodsUsages == that.isMethodsUsages;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isMethodsUsages ? 1 : 0);
        result = 31 * result + (this.isFieldsUsages ? 1 : 0);
        result = 31 * result + (this.isDerivedClasses ? 1 : 0);
        result = 31 * result + (this.isImplementingClasses ? 1 : 0);
        result = 31 * result + (this.isDerivedInterfaces ? 1 : 0);
        result = 31 * result + (this.isCheckDeepInheritance ? 1 : 0);
        result = 31 * result + (this.isIncludeInherited ? 1 : 0);
        return result;
    }
}

