/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleClasspathCombo
extends JComboBox<Item> {
    private final Item[] myOptionItems;
    private boolean myPreventPopupClosing;

    public ModuleClasspathCombo(Item ... optionItems) {
        this.myOptionItems = optionItems;
        this.setRenderer(new ListRenderer());
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)this, item -> ((Item)item).myModule == null ? "" : ((Item)item).myModule.getName());
    }

    @Override
    public void setPopupVisible(boolean visible) {
        if (visible || !this.myPreventPopupClosing) {
            super.setPopupVisible(visible);
        }
        this.myPreventPopupClosing = false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public CollectionComboBoxModel<Item> buildModel(Project project) {
        @NotNull List items = ContainerUtil.mapNotNull((Object[])ModuleManager.getInstance((Project)project).getModules(), module -> ModuleClasspathCombo.isModuleAccepted(module) ? new Item((Module)module) : null);
        items.sort(Comparator.comparing(o -> ((Item)o).myModule.getName()));
        ModelWithOptions model = new ModelWithOptions();
        model.add(items);
        model.add(new Item((String)null));
        model.add(Arrays.asList(this.myOptionItems));
        this.setModel(model);
        return model;
    }

    private static boolean isModuleAccepted(Module module) {
        return ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module));
    }

    public void reset(ModuleBasedConfiguration configuration) {
        CollectionComboBoxModel<Item> model = this.buildModel(configuration.getProject());
        Module module = configuration.getConfigurationModule().getModule();
        this.setSelectedItem(ContainerUtil.find((Iterable)model.getItems(), item -> module == ((Item)item).myModule));
    }

    public void applyTo(ModuleBasedConfiguration configuration) {
        configuration.setModule(this.getSelectedModule());
    }

    @Nullable
    public Module getSelectedModule() {
        Item item = (Item)this.getSelectedItem();
        return item != null ? item.myModule : null;
    }

    private static class ListRenderer
    extends ColoredListCellRenderer<Item> {
        private final JCheckBox myCheckBox = new JBCheckBox();

        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends Item> list, Item value2, int index, boolean isSelected, boolean cellHasFocus) {
            if (value2 == null || value2.myModule != null) {
                return super.getListCellRendererComponent(list, (Object)value2, index, isSelected, cellHasFocus);
            }
            if (value2.myOptionName == null) {
                JPanel pane = new JPanel(new GridBagLayout());
                pane.setOpaque(false);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                pane.add((Component)new JSeparator(), gbc);
                return pane;
            }
            this.myCheckBox.setOpaque(false);
            this.myCheckBox.setText(value2.myOptionName);
            this.myCheckBox.setSelected(value2.myOptionValue);
            return this.myCheckBox;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Item> list, Item value2, int index, boolean selected, boolean hasFocus) {
            if (value2 == null) {
                return;
            }
            if (index == -1) {
                this.append("-cp ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.append(value2.myModule.getName());
            } else {
                this.append(value2.myModule.getName());
            }
        }
    }

    private class ModelWithOptions
    extends CollectionComboBoxModel<Item> {
        private ModelWithOptions() {
        }

        public void setSelectedItem(@Nullable Object o) {
            Item item = (Item)o;
            if (item == null || item.myModule != null) {
                ModuleClasspathCombo.this.myPreventPopupClosing = false;
                super.setSelectedItem((Object)item);
            } else {
                item.myOptionValue = !item.myOptionValue;
                ModuleClasspathCombo.this.myPreventPopupClosing = true;
                this.update();
            }
        }
    }

    public static class Item {
        private Module myModule;
        private String myOptionName;
        public boolean myOptionValue;

        public Item(Module module) {
            this.myModule = module;
        }

        public Item(String optionName) {
            this.myOptionName = optionName;
        }
    }
}

