/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.testIntegration.TestFailedLineManager;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TestFailedLineInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                TestStateStorage.Record state = TestFailedLineManager.getInstance(holder.getProject()).getFailedLineState(call);
                if (state == null) {
                    return;
                }
                if (state.magnitude <= TestStateInfo.Magnitude.IGNORED_INDEX.getValue()) {
                    return;
                }
                LocalQuickFix[] fixes = new LocalQuickFix[]{new DebugFailedTestFix((PsiElement)call, state.topStacktraceLine), new RunActionFix((PsiElement)call, "Run")};
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)holder.getProject()).createProblemDescriptor(nameElement, state.errorMessage, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                descriptor.setTextAttributes(CodeInsightColors.RUNTIME_ERROR);
                holder.registerProblem(descriptor);
            }
        };
    }

    private static class RunActionFix
    implements LocalQuickFix,
    Iconable {
        private final ConfigurationContext myContext;
        private final Executor myExecutor;
        private final RunnerAndConfigurationSettings myConfiguration;

        RunActionFix(PsiElement element, String executorId) {
            this.myExecutor = ExecutorRegistry.getInstance().getExecutorById(executorId);
            this.myContext = new ConfigurationContext(element);
            this.myConfiguration = this.myContext.getConfiguration();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String text2 = this.myExecutor.getStartActionText(ProgramRunnerUtil.shortenName((String)this.myConfiguration.getName(), (int)0));
            return UIUtil.removeMnemonic((String)text2);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)this.myConfiguration, (Executor)this.myExecutor);
        }

        public Icon getIcon(int flags) {
            return this.myExecutor.getIcon();
        }
    }

    private static class DebugFailedTestFix
    extends RunActionFix {
        private final String myTopStacktraceLine;

        DebugFailedTestFix(PsiElement element, String topStacktraceLine) {
            super(element, "Debug");
            this.myTopStacktraceLine = topStacktraceLine;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Document document;
            StackTraceLine line = new StackTraceLine(project, this.myTopStacktraceLine);
            Location<PsiMethod> location = line.getMethodLocation(project);
            if (location != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(((PsiMethod)location.getPsiElement()).getContainingFile())) != null) {
                DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().addLineBreakpoint(document, line.getLineNumber());
            }
            super.applyFix(project, descriptor);
        }
    }
}

