/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.PersistentObjectSeq;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestModuleIndex {
    private static final Logger LOG = Logger.getInstance(TestModuleIndex.class);
    private final PersistentHashMap<Integer, TIntArrayList> myTestNameToRunModule;
    private final PersistentEnumeratorDelegate<String> myModuleNameEnumerator;

    public TestModuleIndex(@NotNull Path basePath, @NotNull PersistentObjectSeq persistentObjectSeq) throws IOException {
        Path moduleNameEnumeratorFile = basePath.resolve("moduleName.enum");
        this.myModuleNameEnumerator = new PersistentEnumeratorDelegate(moduleNameEnumeratorFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 64);
        persistentObjectSeq.add(this.myModuleNameEnumerator);
        Path testModuleIndexFile = basePath.resolve("testModule.index");
        this.myTestNameToRunModule = new PersistentHashMap(testModuleIndexFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntSeqExternalizer());
    }

    void appendModuleData(int testId, @Nullable String moduleName) throws IOException {
        if (moduleName != null) {
            int moduleId = this.myModuleNameEnumerator.enumerate((Object)moduleName);
            TIntArrayList previousRunModules = (TIntArrayList)this.myTestNameToRunModule.get((Object)moduleId);
            if (previousRunModules != null && previousRunModules.contains(moduleId)) {
                return;
            }
            this.myTestNameToRunModule.appendData((Object)testId, out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)moduleId));
        }
    }

    @NotNull
    Collection<String> getTestRunModules(int testId) throws IOException {
        TIntArrayList moduleIds = (TIntArrayList)this.myTestNameToRunModule.get((Object)testId);
        if (moduleIds == null) {
            return Collections.emptySet();
        }
        ArrayList<String> result = new ArrayList<String>(moduleIds.size());
        for (int i = 0; i < moduleIds.size(); ++i) {
            int moduleId = moduleIds.get(i);
            String moduleName = (String)this.myModuleNameEnumerator.valueOf(moduleId);
            if (!LOG.assertTrue(moduleName != null)) continue;
            result.add(moduleName);
        }
        return result;
    }

    void removeTest(int testId) throws IOException {
        this.myTestNameToRunModule.remove((Object)testId);
    }

    private static class IntSeqExternalizer
    implements DataExternalizer<TIntArrayList> {
        private IntSeqExternalizer() {
        }

        public void save(@NotNull DataOutput dataOutput, TIntArrayList testNameIds) throws IOException {
            for (int testNameId : testNameIds.toNativeArray()) {
                DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)testNameId);
            }
        }

        public TIntArrayList read(@NotNull DataInput dataInput) throws IOException {
            TIntHashSet result = new TIntHashSet();
            while (((InputStream)((Object)dataInput)).available() > 0) {
                int id = DataInputOutputUtil.readINT((DataInput)dataInput);
                result.add(id);
            }
            return new TIntArrayList(result.toArray());
        }
    }
}

