/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFilesIndex
extends MapReduceIndex<Integer, Void, UsedSources> {
    private static final IndexExtension<Integer, Void, UsedSources> INDEX_EXTENSION = new IndexExtension<Integer, Void, UsedSources>(){

        @NotNull
        public IndexId<Integer, Void> getName() {
            return IndexId.create((String)"jvm.discovered.test.files");
        }

        @NotNull
        public DataIndexer<Integer, Void, UsedSources> getIndexer() {
            return inputData -> inputData.myUsedFiles;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<Void> getValueExternalizer() {
            return VoidDataExternalizer.INSTANCE;
        }

        public int getVersion() {
            return 10;
        }
    };

    protected TestFilesIndex(@NotNull Path file) throws IOException {
        super(INDEX_EXTENSION, (IndexStorage)new MyIndexStorage(file), (ForwardIndex)new PersistentMapBasedForwardIndex(file.resolve("forward.idx"), false), (ForwardIndexAccessor)new KeyCollectionForwardIndexAccessor((DataExternalizer)new IntCollectionDataExternalizer()));
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable e) {
    }

    @Nullable
    Collection<Integer> getTestDataFor(int testId) throws IOException {
        ForwardIndex forwardIndex = this.getForwardIndex();
        KeyCollectionForwardIndexAccessor forwardIndexAccessor = (KeyCollectionForwardIndexAccessor)this.getForwardIndexAccessor();
        return (Collection)forwardIndexAccessor.deserializeData(forwardIndex.get(Integer.valueOf(testId)));
    }

    private static class MyIndexStorage
    extends MapIndexStorage<Integer, Void> {
        protected MyIndexStorage(@NotNull Path storageFile) throws IOException {
            super(storageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)VoidDataExternalizer.INSTANCE, 4096, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }
}

