/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.IntArrayExternalizer;
import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class DiscoveredTestsIndex
extends MapReduceIndex<Integer, IntList, UsedSources> {
    private static final IndexExtension<Integer, IntList, UsedSources> INDEX_EXTENSION = new IndexExtension<Integer, IntList, UsedSources>(){

        @NotNull
        public IndexId<Integer, IntList> getName() {
            return IndexId.create((String)"jvm.discovered.tests");
        }

        @NotNull
        public DataIndexer<Integer, IntList, UsedSources> getIndexer() {
            return inputData -> inputData.myUsedMethods;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<IntList> getValueExternalizer() {
            return IntArrayExternalizer.INSTANCE;
        }

        public int getVersion() {
            return 10;
        }
    };

    DiscoveredTestsIndex(@NotNull Path file) throws IOException {
        super(INDEX_EXTENSION, (IndexStorage)new MyIndexStorage(file), (ForwardIndex)new PersistentMapBasedForwardIndex(file.resolve("forward.idx"), false), (ForwardIndexAccessor)new KeyCollectionForwardIndexAccessor((DataExternalizer)new IntCollectionDataExternalizer()));
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable e) {
    }

    public boolean containsDataFrom(int testId) throws IOException {
        return this.getForwardIndex().get(Integer.valueOf(testId)) != null;
    }

    private static class MyIndexStorage
    extends MapIndexStorage<Integer, IntList> {
        protected MyIndexStorage(@NotNull Path storageFile) throws IOException {
            super(storageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)IntArrayExternalizer.INSTANCE, 4096, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }
}

