/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTreeModel;
import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiscoveredTestsTree
extends Tree
implements DataProvider,
Disposable {
    private final DiscoveredTestsTreeModel myModel = new DiscoveredTestsTreeModel();

    DiscoveredTestsTree(String title) {
        this.setModel((TreeModel)new AsyncTreeModel((TreeModel)((Object)this.myModel), (Disposable)this));
        HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), DiscoveredTestsTree::obj2psi);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)((Object)this), o -> {
            PsiElement component = DiscoveredTestsTree.obj2psi(o.getLastPathComponent());
            return component instanceof PsiMember ? ((PsiMember)component).getName() : null;
        }, true);
        this.getSelectionModel().setSelectionMode(2);
        this.getEmptyText().setText(ExecutionBundle.message((String)"no.tests.captured.for.0", (Object[])new Object[]{title}));
        this.setPaintBusy(true);
        this.setRootVisible(false);
        this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value2 instanceof DiscoveredTestsTreeModel.Node) {
                    DiscoveredTestsTreeModel.Node node = (DiscoveredTestsTreeModel.Node)value2;
                    this.setIcon(node.getIcon());
                    String name2 = node.getName();
                    assert (name2 != null);
                    this.append(name2);
                    if (node instanceof DiscoveredTestsTreeModel.Node.Clazz) {
                        String packageName = ((DiscoveredTestsTreeModel.Node.Clazz)node).getPackageName();
                        if (packageName != null) {
                            this.append(FontUtil.spaceAndThinSpace() + packageName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        int testMethodCount = DiscoveredTestsTree.this.myModel.getChildren(value2).size();
                        this.append(" / " + (testMethodCount != 1 ? testMethodCount + " tests" : "1 test"), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (node instanceof DiscoveredTestsTreeModel.Node.Method) {
                        boolean isParametrized;
                        boolean bl = isParametrized = !((DiscoveredTestsTreeModel.Node.Method)node).getParameters().isEmpty();
                        if (isParametrized) {
                            this.append(FontUtil.spaceAndThinSpace() + "parametrized", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                    }
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)true, (boolean)false);
                }
            }
        });
        this.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){
            boolean myAlreadyDone;

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type2) {
                if (!this.myAlreadyDone && DiscoveredTestsTree.this.getTestCount() != 0) {
                    this.myAlreadyDone = true;
                    EdtInvocationManager.getInstance().invokeLater(() -> {
                        TreeUtil.collapseAll((JTree)((Object)DiscoveredTestsTree.this), (int)0);
                        TreeUtil.promiseSelectFirst((JTree)((Object)DiscoveredTestsTree.this));
                    });
                }
            }
        });
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this));
        CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
        CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
    }

    public void dispose() {
    }

    public void addTest(@NotNull PsiClass testClass, @Nullable PsiMethod testMethod, @Nullable String parameter2) {
        this.myModel.addTest(testClass, testMethod, parameter2);
    }

    @NotNull
    public Set<Module> getContainingModules() {
        return this.myModel.getTestClasses().stream().map(element -> {
            SmartPsiElementPointer pointer = element.getPointer();
            return ModuleUtilCore.findModuleForFile((VirtualFile)pointer.getVirtualFile(), (Project)pointer.getProject());
        }).filter(module -> module != null).collect(Collectors.toSet());
    }

    TestMethodUsage @NotNull [] getTestMethods() {
        return this.myModel.getTestMethods();
    }

    @Nullable
    public PsiElement getSelectedElement() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        return DiscoveredTestsTree.obj2psi(path == null ? null : path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement obj2psi(@Nullable Object obj) {
        return Optional.ofNullable(ObjectUtils.tryCast((Object)obj, DiscoveredTestsTreeModel.Node.class)).map(n -> n.getPointer()).map(p -> p.getElement()).orElse(null);
    }

    public int getTestCount() {
        return this.myModel.getTestCount();
    }

    public int getTestClassesCount() {
        return this.myModel.getTestClassesCount();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            TreePath[] paths = this.getSelectionModel().getSelectionPaths();
            SmartList result = new SmartList();
            TreeModel model = this.getModel();
            for (TreePath p : paths) {
                Object o = p.getLastPathComponent();
                PsiElement e = DiscoveredTestsTree.obj2psi(o);
                if (e instanceof PsiMethod) {
                    result.add(e);
                    continue;
                }
                int count = model.getChildCount(e);
                if (count == 0 && e != null) {
                    result.add(e);
                    continue;
                }
                for (int i = 0; i < count; ++i) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)ObjectUtils.tryCast((Object)DiscoveredTestsTree.obj2psi(model.getChild(e, i)), PsiMethod.class));
                }
            }
            return result.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getSelectedElement();
        }
        if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
            return PopupUtil.getPopupContainerFor((Component)((Object)this));
        }
        return null;
    }
}

