/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.LocalTestDiscoveryProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TestDiscoveryProducer {
    public static final ExtensionPointName<TestDiscoveryProducer> EP = ExtensionPointName.create((String)"com.intellij.testDiscoveryProducer");
    public static final Logger LOG = Logger.getInstance(LocalTestDiscoveryProducer.class);

    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project var1, @NotNull List<? extends Couple<String>> var2, byte var3);

    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project var1, @NotNull List<String> var2, byte var3);

    public boolean isRemote();

    public static void consumeDiscoveredTests(@NotNull Project project, @NotNull List<Couple<String>> classesAndMethods, byte frameworkId, @NotNull List<String> filePaths, @NotNull TestProcessor processor2) {
        MultiMap<String, String> visitedTests = new MultiMap<String, String>(){

            @NotNull
            protected Collection<String> createCollection() {
                return new THashSet();
            }
        };
        for (TestDiscoveryProducer producer : EP.getExtensionList()) {
            for (Map.Entry entry : ContainerUtil.concat((Iterable)producer.getDiscoveredTests(project, classesAndMethods, frameworkId).entrySet(), (Iterable)producer.getDiscoveredTestsForFiles(project, filePaths, frameworkId).entrySet())) {
                String className2 = (String)entry.getKey();
                for (String methodRawName : (Collection)entry.getValue()) {
                    if (visitedTests.get((Object)className2).contains(methodRawName)) continue;
                    visitedTests.putValue((Object)className2, (Object)methodRawName);
                    Couple<String> couple = TestDiscoveryProducer.extractParameter(methodRawName);
                    if (processor2.process(className2, (String)couple.first, (String)couple.second)) continue;
                    return;
                }
            }
        }
    }

    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project var1, @NotNull List<? extends Couple<String>> var2, byte var3);

    @NotNull
    public List<String> getAffectedFilePathsByClassName(@NotNull Project var1, @NotNull String var2, byte var3);

    @NotNull
    public List<String> getFilesWithoutTests(@NotNull Project var1, @NotNull Collection<String> var2) throws IOException;

    public static void consumeAffectedPaths(@NotNull Project project, @NotNull List<? extends Couple<String>> testFqns, @NotNull Consumer<? super String> pathsConsumer, byte frameworkId) {
        for (TestDiscoveryProducer extension : EP.getExtensionList()) {
            for (String path : extension.getAffectedFilePaths(project, testFqns, frameworkId)) {
                pathsConsumer.consume((Object)path);
            }
        }
    }

    public static void consumeAffectedPaths(@NotNull Project project, @NotNull String testClassName, @NotNull Consumer<? super String> pathsConsumer, byte frameworkId) {
        for (TestDiscoveryProducer extension : EP.getExtensionList()) {
            for (String path : extension.getAffectedFilePathsByClassName(project, testClassName, frameworkId)) {
                pathsConsumer.consume((Object)path);
            }
        }
    }

    @NotNull
    public static Couple<String> extractParameter(@NotNull String rawName) {
        int idx = rawName.indexOf(91);
        return idx == -1 ? Couple.of((Object)rawName, null) : Couple.of((Object)rawName.substring(0, idx), (Object)rawName.substring(idx));
    }

    @FunctionalInterface
    public static interface PsiTestProcessor {
        public boolean process(@NotNull PsiClass var1, @Nullable PsiMethod var2, @Nullable String var3);
    }

    @FunctionalInterface
    public static interface TestProcessor {
        public boolean process(@NotNull String var1, @NotNull String var2, @Nullable String var3);
    }
}

