/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.execution.testDiscovery.indices.DiscoveredTestDataHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Couple;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class TestDiscoveryIndex
implements Disposable {
    static final Logger LOG = Logger.getInstance(TestDiscoveryIndex.class);
    private volatile DiscoveredTestDataHolder myHolder;
    private final Object myLock = new Object();
    private final Path basePath;

    public static TestDiscoveryIndex getInstance(@NotNull Project project) {
        return (TestDiscoveryIndex)project.getService(TestDiscoveryIndex.class);
    }

    TestDiscoveryIndex(@NotNull Project project) {
        this(TestDiscoveryExtension.baseTestDiscoveryPathForProject(project));
    }

    @NonInjectable
    public TestDiscoveryIndex(@NotNull Path basePath) {
        this.basePath = basePath;
    }

    public boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        Boolean result = (Boolean)this.executeUnderLock(holder -> holder.hasTestTrace(testClassName, testMethodName, frameworkId));
        return result == Boolean.TRUE;
    }

    public void removeTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        this.executeUnderLock(holder -> {
            holder.removeTestTrace(testClassName, testMethodName, frameworkId);
            return null;
        });
    }

    @NotNull
    public MultiMap<String, String> getTestsByFile(String relativePath, byte frameworkId) {
        MultiMap map2 = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByFile(relativePath, frameworkId));
        return map2 == null ? MultiMap.empty() : map2;
    }

    @NotNull
    public MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) {
        MultiMap map2 = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByClassName(classFQName, frameworkId));
        return map2 == null ? MultiMap.empty() : map2;
    }

    @NotNull
    public MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        MultiMap map2 = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByMethodName(classFQName, methodName, frameworkId));
        return map2 == null ? MultiMap.empty() : map2;
    }

    @NotNull
    public Collection<String> getTestModulesByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        Collection modules = (Collection)this.executeUnderLock(holder -> holder.getTestModulesByMethodName(classFQName, methodName, frameworkId));
        return modules == null ? Collections.emptySet() : modules;
    }

    @NotNull
    public Collection<String> getAffectedFiles(Couple<String> testQName, byte frameworkId) {
        Collection files = (Collection)this.executeUnderLock(holder -> holder.getAffectedFiles(testQName, frameworkId));
        return files == null ? Collections.emptySet() : files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            DiscoveredTestDataHolder holder = this.myHolder;
            if (holder != null) {
                holder.dispose();
                this.myHolder = null;
            }
        }
    }

    public void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull List<String> usedFiles, @Nullable String moduleName, byte frameworkId) {
        this.executeUnderLock(holder -> {
            holder.updateTestData(testClassName, testMethodName, usedMethods, usedFiles, moduleName, frameworkId);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredTestDataHolder getHolder() {
        DiscoveredTestDataHolder holder = this.myHolder;
        if (holder == null) {
            Object object = this.myLock;
            synchronized (object) {
                holder = this.myHolder;
                if (holder == null && this.basePath != null) {
                    this.myHolder = holder = new DiscoveredTestDataHolder(this.basePath);
                }
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeUnderLock(ThrowableConvertor<DiscoveredTestDataHolder, R, IOException> action) {
        Object object = this.myLock;
        synchronized (object) {
            DiscoveredTestDataHolder holder = this.getHolder();
            if (holder == null || holder.isDisposed()) {
                return null;
            }
            try {
                return (R)action.convert((Object)holder);
            }
            catch (Throwable throwable) {
                LOG.error("Unexpected problem", throwable);
                holder.dispose();
                PathKt.delete((Path)this.basePath);
                this.myHolder = null;
                return null;
            }
        }
    }

    static final class MyPostStartUpActivity
    implements StartupActivity.DumbAware {
        MyPostStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NonUrgentExecutor.getInstance().execute(() -> {
                TestDiscoveryIndex service = TestDiscoveryIndex.getInstance(project);
                if (!Files.exists(service.basePath, new LinkOption[0])) {
                    return;
                }
                service.getHolder();
            });
        }
    }
}

