/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ui.ClassBrowser;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ClassEditorField
extends EditorTextField {
    public static ClassEditorField createClassField(Project project, Computable<? extends Module> moduleSelector) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment("", (PsiElement)defaultPackage, true, true);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.PROJECT_SCOPE_VISIBLE);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        final ClassEditorField field = new ClassEditorField(document, project, (FileType)JavaFileType.INSTANCE);
        final ClassBrowser.AppClassBrowser<EditorTextField> browser = new ClassBrowser.AppClassBrowser<EditorTextField>(project, moduleSelector){

            public String getText() {
                return field.getText();
            }

            public void actionPerformed(ActionEvent e) {
                String text2 = this.showDialog();
                if (text2 != null) {
                    field.setText(text2);
                }
            }
        };
        field.addSettingsProvider(editor -> {
            ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineVariables, (Icon)AllIcons.General.InlineVariablesHover, (String)ComponentWithBrowseButton.getTooltip(), () -> browser.actionPerformed(null));
            ExtendableEditorSupport.setupExtension((EditorEx)editor, (Color)field.getBackground(), (ExtendableTextComponent.Extension)extension);
        });
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                browser.actionPerformed(null);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), (JComponent)((Object)field));
        return field;
    }

    private ClassEditorField(Document document, Project project, FileType fileType) {
        super(document, project, fileType);
    }
}

