/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJavaRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        RunConfiguration runConfiguration = settings.getConfiguration();
        return runConfiguration instanceof SingleClassConfiguration || runConfiguration instanceof CommonJavaRunConfigurationParameters && runConfiguration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule() instanceof JavaRunConfigurationModule;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull RunDashboardRunConfigurationNode node) {
        return CommonJavaRunDashboardCustomizer.findMainClass(node.getConfigurationSettings().getConfiguration());
    }

    @Nullable
    private static PsiClass findMainClass(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration instanceof SingleClassConfiguration) {
            return ((SingleClassConfiguration)runConfiguration).getMainClass();
        }
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters) || !(runConfiguration instanceof ModuleBasedConfiguration)) {
            return null;
        }
        RunConfigurationModule configurationModule = ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule();
        if (!(configurationModule instanceof JavaRunConfigurationModule)) {
            return null;
        }
        String runClassName = ((CommonJavaRunConfigurationParameters)runConfiguration).getRunClass();
        if (runClassName == null) {
            return null;
        }
        return ((JavaRunConfigurationModule)configurationModule).findClass(runClassName);
    }
}

