/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.lang;

import com.intellij.diff.lang.LangDiffIgnoredRangeProvider;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaDiffIgnoredRangeProvider
extends LangDiffIgnoredRangeProvider {
    @NotNull
    public String getDescription() {
        return JavaBundle.message((String)"ignore.imports.and.formatting", (Object[])new Object[0]);
    }

    protected boolean accepts(@NotNull Project project, @NotNull Language language) {
        return JavaLanguage.INSTANCE.equals(language);
    }

    @NotNull
    protected List<TextRange> computeIgnoredRanges(@NotNull Project project, @NotNull CharSequence text2, @NotNull Language language) {
        return (List)ReadAction.compute(() -> {
            final ArrayList result = new ArrayList();
            PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("", language, text2);
            psiFile.accept(new PsiElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element.getTextLength() == 0) {
                        return;
                    }
                    if (JavaDiffIgnoredRangeProvider.isIgnored(element)) {
                        result.add(element.getTextRange());
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return result;
        });
    }

    private static boolean isIgnored(@NotNull PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        return element instanceof PsiImportList;
    }
}

