/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentEditableArea
implements EditableArea {
    private final JComponent myComponent;
    private final EventListenerList myListenerList = new EventListenerList();
    private List<RadComponent> mySelection = new ArrayList<RadComponent>();

    public ComponentEditableArea(JComponent component) {
        this.myComponent = component;
    }

    @Override
    public void addSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.add(ComponentSelectionListener.class, listener);
    }

    @Override
    public void removeSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.remove(ComponentSelectionListener.class, listener);
    }

    protected void fireSelectionChanged() {
        for (ComponentSelectionListener listener : (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectionChanged(this);
        }
    }

    @Override
    @NotNull
    public List<RadComponent> getSelection() {
        return this.mySelection;
    }

    @Override
    public boolean isSelected(@NotNull RadComponent component) {
        return this.mySelection.contains((Object)component);
    }

    @Override
    public void select(@NotNull RadComponent component) {
        this.mySelection = new ArrayList<RadComponent>();
        this.mySelection.add(component);
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(@NotNull RadComponent component) {
        this.mySelection.remove((Object)component);
        this.fireSelectionChanged();
    }

    @Override
    public void appendSelection(@NotNull RadComponent component) {
        this.mySelection.remove((Object)component);
        this.mySelection.add(component);
        this.fireSelectionChanged();
    }

    @Override
    public void setSelection(@NotNull List<RadComponent> components) {
        this.mySelection = new ArrayList<RadComponent>(components);
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(@NotNull Collection<RadComponent> components) {
        this.mySelection.removeAll(components);
        this.fireSelectionChanged();
    }

    @Override
    public void deselectAll() {
        this.mySelection = new ArrayList<RadComponent>();
        this.fireSelectionChanged();
    }

    @Override
    public void scrollToSelection() {
    }

    @Override
    public void setCursor(@Nullable Cursor cursor) {
        this.myComponent.setCursor(cursor);
    }

    @Override
    public void setDescription(@Nullable String text2) {
        ActionMenu.showDescriptionInStatusBar((boolean)true, (Component)this.myComponent, (String)text2);
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        return this.myComponent;
    }

    @Override
    public boolean isTree() {
        return false;
    }

    @Override
    @Nullable
    public FeedbackTreeLayer getFeedbackTreeLayer() {
        return null;
    }
}

