/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.AbstractEditOperation;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineInsertFeedback;
import com.intellij.designer.designSurface.feedbacks.RectangleFeedback;
import com.intellij.designer.model.RadComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlowBaseOperation
extends AbstractEditOperation {
    protected final boolean myHorizontal;
    protected RectangleFeedback myFirstInsertFeedback;
    protected LineInsertFeedback myInsertFeedback;
    protected Rectangle myBounds;
    protected RadComponent myChildTarget;
    protected boolean myInsertBefore;

    public AbstractFlowBaseOperation(RadComponent container, OperationContext context, boolean horizontal) {
        super(container, context);
        this.myHorizontal = horizontal;
    }

    protected void createFeedback() {
        if (this.myFirstInsertFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myBounds = this.myContainer.getBounds(layer);
            this.createFirstInsertFeedback();
            this.createInsertFeedback();
            if (this.getChildren().isEmpty()) {
                layer.add(this.myFirstInsertFeedback);
            } else {
                layer.add(this.myInsertFeedback);
            }
            layer.repaint();
        }
    }

    protected List<RadComponent> getChildren() {
        return this.myContainer.getChildren();
    }

    protected abstract void createInsertFeedback();

    protected abstract void createFirstInsertFeedback();

    @Override
    public void showFeedback() {
        this.createFeedback();
        List<RadComponent> children = this.getChildren();
        if (!children.isEmpty()) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            Point location = this.myContext.getLocation();
            this.myChildTarget = null;
            if (this.myHorizontal) {
                this.handleHorizontal(children, layer, location);
            } else {
                this.handleVertical(children, layer, location);
            }
            if (this.myChildTarget == null) {
                this.myChildTarget = this.getSideChildTarget();
            }
            Rectangle targetBounds = this.getBounds(this.myChildTarget, layer);
            this.myInsertBefore = this.myHorizontal ? (double)location.x < targetBounds.getCenterX() : (double)location.y < targetBounds.getCenterY();
            this.setInsertFeedbackBounds(targetBounds);
            layer.repaint();
        }
    }

    protected void handleHorizontal(List<RadComponent> children, FeedbackLayer layer, Point location) {
        for (RadComponent child : children) {
            Rectangle childBounds = this.getBounds(child, layer);
            if (childBounds.x > location.x || !((double)location.x <= childBounds.getMaxX())) continue;
            this.myChildTarget = child;
            break;
        }
    }

    protected void handleVertical(List<RadComponent> children, FeedbackLayer layer, Point location) {
        for (RadComponent child : children) {
            Rectangle childBounds = this.getBounds(child, layer);
            if (childBounds.y > location.y || !((double)location.y <= childBounds.getMaxY())) continue;
            this.myChildTarget = child;
            break;
        }
    }

    protected void setInsertFeedbackBounds(Rectangle targetBounds) {
        if (this.myHorizontal) {
            if (this.myInsertBefore) {
                this.myInsertFeedback.setLocation(targetBounds.x, this.myBounds.y);
            } else {
                this.myInsertFeedback.setLocation(targetBounds.x + targetBounds.width, this.myBounds.y);
            }
        } else if (this.myInsertBefore) {
            this.myInsertFeedback.setLocation(this.myBounds.x, targetBounds.y);
        } else {
            this.myInsertFeedback.setLocation(this.myBounds.x, targetBounds.y + targetBounds.height);
        }
    }

    protected Rectangle getBounds(RadComponent component, FeedbackLayer layer) {
        return component.getBounds(layer);
    }

    private RadComponent getSideChildTarget() {
        Point location = this.myContext.getLocation();
        List<RadComponent> children = this.getChildren();
        RadComponent lastChild = children.get(children.size() - 1);
        Rectangle childBounds = lastChild.getBounds(this.myContext.getArea().getFeedbackLayer());
        if (this.myHorizontal) {
            if ((double)location.x >= childBounds.getMaxX()) {
                return lastChild;
            }
            return children.get(0);
        }
        if ((double)location.y >= childBounds.getMaxY()) {
            return lastChild;
        }
        return children.get(0);
    }

    @Override
    public void eraseFeedback() {
        if (this.myFirstInsertFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove(this.myFirstInsertFeedback);
            layer.remove(this.myInsertFeedback);
            layer.repaint();
            this.myFirstInsertFeedback = null;
            this.myInsertFeedback = null;
        }
    }

    @Override
    public boolean canExecute() {
        if (this.myContext.isMove()) {
            if (this.myComponents.contains((Object)this.myChildTarget)) {
                return false;
            }
            List<RadComponent> children = this.getChildren();
            int index = children.indexOf((Object)this.myChildTarget) + (this.myInsertBefore ? -1 : 1);
            if (0 <= index && index < children.size()) {
                return !this.myComponents.contains((Object)children.get(index));
            }
        }
        return true;
    }

    @Override
    public void execute() throws Exception {
        if (this.myChildTarget == null || this.myInsertBefore) {
            this.execute(this.myChildTarget);
        } else {
            List<RadComponent> children = this.getChildren();
            int index = children.indexOf((Object)this.myChildTarget) + 1;
            if (index < children.size()) {
                this.execute(children.get(index));
            } else {
                this.execute(null);
            }
        }
    }

    protected abstract void execute(@Nullable RadComponent var1) throws Exception;
}

