/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Type;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFieldInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final UserExpressionDescriptorImpl myDescriptor;
    protected final EnumerationChildrenRenderer myRenderer;

    public CustomFieldInplaceEditor(@NotNull XDebuggerTreeNode node, @Nullable UserExpressionDescriptorImpl descriptor, @Nullable EnumerationChildrenRenderer renderer) {
        super(node, "customField");
        this.myDescriptor = descriptor;
        this.myRenderer = renderer;
        this.myExpressionEditor.setExpression(descriptor != null ? TextWithImportsImpl.toXExpression(descriptor.getEvaluationText()) : null);
        ValueDescriptorImpl parentDescriptor = ((JavaValue)((XValueContainerNode)node.getParent()).getValueContainer()).getDescriptor();
        Pair<PsiElement, PsiType> pair2 = DebuggerUtilsImpl.getPsiClassAndType(CustomFieldInplaceEditor.getTypeName(parentDescriptor), this.getProject());
        if (pair2.first != null) {
            this.myExpressionEditor.setContext((PsiElement)pair2.first);
        }
    }

    public static void editNew(final @NotNull XValueNodeImpl parentNode) {
        final ValueDescriptorImpl descriptor = ((JavaValue)parentNode.getValueContainer()).getDescriptor();
        EnumerationChildrenRenderer renderer = EnumerationChildrenRenderer.getCurrent(descriptor);
        final XDebuggerTreeNode newNode = parentNode.addTemporaryEditorNode(AllIcons.Debugger.Db_watch, null);
        DebuggerUIUtil.invokeLater(() -> new CustomFieldInplaceEditor(newNode, null, renderer){

            public void cancelEditing() {
                super.cancelEditing();
                parentNode.removeTemporaryEditorNode(newNode);
            }

            @Override
            protected List<EnumerationChildrenRenderer.ChildInfo> getRendererChildren() {
                if (this.myRenderer != null) {
                    return this.myRenderer.getChildren();
                }
                String name2 = CustomFieldInplaceEditor.getTypeName(descriptor);
                EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer();
                enumerationChildrenRenderer.setAppendDefaultChildren(true);
                Renderer lastRenderer = descriptor.getLastRenderer();
                if (lastRenderer instanceof CompoundReferenceRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)lastRenderer) && !(((CompoundReferenceRenderer)lastRenderer).getChildrenRenderer() instanceof ExpressionChildrenRenderer)) {
                    ((CompoundReferenceRenderer)lastRenderer).setChildrenRenderer(enumerationChildrenRenderer);
                } else {
                    CompoundReferenceRenderer renderer = NodeRendererSettings.getInstance().createCompoundReferenceRenderer(name2, name2, null, enumerationChildrenRenderer);
                    renderer.setEnabled(true);
                    NodeRendererSettings.getInstance().getCustomRenderers().addRenderer(renderer);
                    NodeRendererSettings.getInstance().fireRenderersChanged();
                }
                return enumerationChildrenRenderer.getChildren();
            }
        }.show());
    }

    @Nullable
    private static String getTypeName(ValueDescriptorImpl descriptor) {
        Type type2 = descriptor.getType();
        return type2 != null ? type2.name() : null;
    }

    protected List<EnumerationChildrenRenderer.ChildInfo> getRendererChildren() {
        return this.myRenderer.getChildren();
    }

    public void doOKAction() {
        List<EnumerationChildrenRenderer.ChildInfo> children = this.getRendererChildren();
        TextWithImports newText = TextWithImportsImpl.fromXExpression(this.myExpressionEditor.getExpression());
        if (this.myDescriptor == null) {
            children.add(0, new EnumerationChildrenRenderer.ChildInfo("", newText, false));
        } else {
            int index = this.myDescriptor.getEnumerationIndex();
            EnumerationChildrenRenderer.ChildInfo old = children.get(index);
            children.set(index, new EnumerationChildrenRenderer.ChildInfo(old.myName, newText, old.myOnDemand));
        }
        this.myTree.putClientProperty((Object)"selection.path", (Object)CustomFieldInplaceEditor.createDummySelectionTreePath(newText.getText(), (XDebuggerTreeNode)this.myNode.getParent()));
        XDebuggerUtilImpl.rebuildTreeAndViews((XDebuggerTree)this.myTree);
        super.doOKAction();
    }

    private static TreePath createDummySelectionTreePath(String name2, XDebuggerTreeNode parentNode) {
        return new XValueNodeImpl(parentNode.getTree(), parentNode, name2, new XValue(){

            public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            }
        }).getPath();
    }

    @Nullable
    protected Rectangle getEditorBounds() {
        Rectangle bounds = super.getEditorBounds();
        if (bounds == null) {
            return null;
        }
        int afterIconX = this.getAfterIconX();
        bounds.x += afterIconX;
        bounds.width -= afterIconX;
        return bounds;
    }
}

