/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.ValueIconRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Color;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class ColorObjectRenderer
extends CompoundRendererProvider {
    private static final Logger LOG = Logger.getInstance(ColorObjectRenderer.class);

    ColorObjectRenderer() {
    }

    @Override
    protected String getName() {
        return "Color";
    }

    @Override
    protected String getClassName() {
        return "java.awt.Color";
    }

    @Override
    protected ValueIconRenderer getIconRenderer() {
        return (descriptor, evaluationContext, listener) -> {
            Value value2 = descriptor.getValue();
            if (value2 instanceof ObjectReference) {
                try {
                    final ObjectReference objRef = (ObjectReference)value2;
                    ReferenceType refType = objRef.referenceType();
                    if (refType instanceof ClassType) {
                        Value rgbValue = null;
                        final Method getRGBMethod = DebuggerUtils.findMethod((ReferenceType)refType, (String)"getRGB", (String)"()I");
                        if (getRGBMethod != null) {
                            Field valueField;
                            ReferenceType rgbMethodDeclaringType = getRGBMethod.declaringType();
                            if (rgbMethodDeclaringType.name().equals("java.awt.Color") && (valueField = rgbMethodDeclaringType.fieldByName("value")) != null) {
                                rgbValue = objRef.getValue(valueField);
                            }
                            if (rgbValue instanceof IntegerValue) {
                                return ColorObjectRenderer.createIcon((IntegerValue)rgbValue);
                            }
                            EvaluationContextImpl evalContext = (EvaluationContextImpl)evaluationContext;
                            final DebugProcessImpl debugProcess = evalContext.getDebugProcess();
                            debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

                                @Override
                                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                    try {
                                        Value rgbValue = debugProcess.invokeMethod(evaluationContext, objRef, getRGBMethod, Collections.emptyList());
                                        if (rgbValue instanceof IntegerValue) {
                                            descriptor.setValueIcon(ColorObjectRenderer.createIcon((IntegerValue)rgbValue));
                                            listener.labelChanged();
                                        }
                                    }
                                    catch (EvaluateException e) {
                                        LOG.info((Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    throw new EvaluateException(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        };
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    private static Icon createIcon(IntegerValue rgbValue) {
        return JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 12, new Color(rgbValue.value(), true), true));
    }
}

