/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier myModifier;
    protected TextWithImports myText;

    protected EvaluationDescriptor(TextWithImports text2, Project project, Value value2) {
        super(project, value2);
        this.myText = text2;
    }

    protected EvaluationDescriptor(TextWithImports text2, Project project) {
        super(project);
        this.setLvalue(false);
        this.myText = text2;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    public PsiCodeFragment createCodeFragment(PsiElement context) {
        TextWithImports text2 = this.getEvaluationText();
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text2, context).createCodeFragment(text2, context, this.myProject);
    }

    @Override
    public final Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction(() -> {});
            EvaluationContextImpl thisEvaluationContext = this.getEvaluationContext(evaluationContext);
            SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
            ExpressionEvaluator evaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                PsiCodeFragment code = this.getEvaluationCode((StackFrameContext)thisEvaluationContext);
                PsiElement psiContext = ContextUtil.getContextElement((StackFrameContext)evaluationContext, position);
                try {
                    return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.getEvaluationText(), psiContext).getEvaluatorBuilder().build((PsiElement)code, position);
                }
                catch (UnsupportedExpressionException ex) {
                    ExpressionEvaluator eval = CompilingEvaluatorImpl.create(this.myProject, code.getContext(), element -> code);
                    if (eval != null) {
                        return eval;
                    }
                    throw ex;
                }
            });
            if (!thisEvaluationContext.getDebugProcess().isAttached()) {
                throw EvaluateExceptionUtil.PROCESS_EXITED;
            }
            StackFrameProxyImpl frameProxy = thisEvaluationContext.getFrameProxy();
            if (frameProxy == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Value value2 = evaluator.evaluate((EvaluationContext)thisEvaluationContext);
            thisEvaluationContext.keep(value2);
            this.myModifier = evaluator.getModifier();
            this.setLvalue(this.myModifier != null);
            return value2;
        }
        catch (IndexNotReadyException ex) {
            throw new EvaluateException("Evaluation is not possible during indexing", (Throwable)ex);
        }
        catch (EvaluateException ex) {
            throw new EvaluateException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (ObjectCollectedException ex) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiCodeFragment evaluationCode = this.getEvaluationCode((StackFrameContext)context);
        if (evaluationCode instanceof PsiExpressionCodeFragment) {
            return ((PsiExpressionCodeFragment)evaluationCode).getExpression();
        }
        throw new EvaluateException(JavaDebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    @Override
    protected boolean isPrintExceptionToConsole() {
        return false;
    }

    @Nullable
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public boolean canSetValue() {
        return super.canSetValue() && this.myModifier != null && this.myModifier.canSetValue();
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }

    @Override
    public XValueModifier getModifier(JavaValue value2) {
        return new JavaValueModifier(value2){

            @Override
            protected void setValueImpl(@NotNull XExpression expression2, @NotNull XValueModifier.XModificationCallback callback) {
                final EvaluationDescriptor evaluationDescriptor = EvaluationDescriptor.this;
                if (evaluationDescriptor.canSetValue()) {
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(EvaluationDescriptor.this.getProject()).getContext();
                    this.set(expression2, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            evaluationDescriptor.getModifier().setValue(1.preprocessValue(evaluationContext, newValue, this.getLType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        @NotNull
                        public Type getLType() throws EvaluateException, ClassNotLoadedException {
                            return evaluationDescriptor.getModifier().getExpectedType();
                        }
                    });
                }
            }
        };
    }
}

