/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapProgressImpl;
import com.intellij.debugger.ui.HotSwapStatusListener;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.debugger.ui.RunHotswapDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

public class HotSwapUIImpl
extends HotSwapUI {
    public static final Key<Boolean> SKIP_HOT_SWAP_KEY = KeyWithDefaultValue.create((String)"skip_hotswap_after_this_compilation", (Object)false);
    private static final Key<HotSwapStatusListener> HOT_SWAP_CALLBACK_KEY = Key.create((String)"hot_swap_callback");
    private final List<HotSwapVetoableListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myAskBeforeHotswap = true;
    private final Project myProject;

    public HotSwapUIImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public void addListener(HotSwapVetoableListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(HotSwapVetoableListener listener) {
        this.myListeners.remove(listener);
    }

    private static boolean shouldDisplayHangWarning(DebuggerSettings settings, List<DebuggerSession> sessions) {
        if (!settings.HOTSWAP_HANG_WARNING_ENABLED) {
            return false;
        }
        return sessions.stream().anyMatch(DebuggerSession::isPaused);
    }

    private void hotSwapSessions(@NotNull List<DebuggerSession> sessions, @Nullable HotSwapStatusListener callback) {
        this.hotSwapSessions(sessions, null, null, callback);
    }

    private void hotSwapSessions(final @NotNull List<DebuggerSession> sessions, @Nullable Map<String, Collection<String>> generatedPaths, @Nullable NotNullLazyValue<? extends List<String>> outputPaths, final @Nullable HotSwapStatusListener callback) {
        boolean shouldAskBeforeHotswap = this.myAskBeforeHotswap;
        this.myAskBeforeHotswap = true;
        DebuggerSettings settings = DebuggerSettings.getInstance();
        String runHotswap = settings.RUN_HOTSWAP_AFTER_COMPILE;
        boolean shouldDisplayHangWarning = HotSwapUIImpl.shouldDisplayHangWarning(settings, sessions);
        final HotSwapStatusListener callbackWrapper = new HotSwapStatusListener(){

            @Override
            public void onCancel(List<DebuggerSession> sessions) {
                if (callback != null) {
                    callback.onCancel(sessions);
                }
            }

            @Override
            public void onSuccess(List<DebuggerSession> sessions) {
                if (callback != null) {
                    callback.onSuccess(sessions);
                }
            }

            @Override
            public void onFailure(List<DebuggerSession> sessions) {
                if (callback != null) {
                    callback.onFailure(sessions);
                }
            }
        };
        if (shouldAskBeforeHotswap && "RunHotswapNever".equals(runHotswap)) {
            callbackWrapper.onCancel(sessions);
            return;
        }
        ArrayList<DebuggerSession> toScan = new ArrayList<DebuggerSession>(sessions);
        ArrayList<DebuggerSession> toUseGenerated = new ArrayList<DebuggerSession>();
        if (generatedPaths != null) {
            toScan.clear();
            for (DebuggerSession session : sessions) {
                if (session.isModifiedClassesScanRequired()) {
                    toScan.add(session);
                } else {
                    toUseGenerated.add(session);
                }
                session.setModifiedClassesScanRequired(false);
            }
        }
        HotSwapProgressImpl findClassesProgress = !toScan.isEmpty() ? this.createHotSwapProgress(callbackWrapper, sessions) : null;
        HotSwapProgressImpl outputPathsProgress = !toUseGenerated.isEmpty() && outputPaths != null ? this.createHotSwapProgress(callbackWrapper, sessions) : null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            HashMap<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
            if (!toUseGenerated.isEmpty()) {
                modifiedClasses.putAll(HotSwapManager.findModifiedClasses(toUseGenerated, generatedPaths));
                if (outputPathsProgress != null) {
                    HotSwapUIImpl.scanForModifiedClassesWithProgress(toUseGenerated, outputPaths, outputPathsProgress).forEach((session, map3) -> modifiedClasses.merge((DebuggerSession)session, (Map<String, HotSwapFile>)map3, (map1, map2) -> {
                        map1.putAll(map2);
                        return map1;
                    }));
                }
            }
            if (findClassesProgress != null) {
                modifiedClasses.putAll(HotSwapUIImpl.scanForModifiedClassesWithProgress(toScan, findClassesProgress));
            }
            Application application = ApplicationManager.getApplication();
            if (modifiedClasses.isEmpty()) {
                String message2 = JavaDebuggerBundle.message((String)"status.hotswap.uptodate", (Object[])new Object[0]);
                HotSwapProgressImpl.NOTIFICATION_GROUP.createNotification(message2, NotificationType.INFORMATION).notify(this.myProject);
                callbackWrapper.onSuccess(sessions);
                return;
            }
            application.invokeLater(() -> {
                int answer;
                if (shouldAskBeforeHotswap && !"RunHotswapAlways".equals(runHotswap)) {
                    RunHotswapDialog dialog = new RunHotswapDialog(this.myProject, sessions, shouldDisplayHangWarning);
                    if (!dialog.showAndGet()) {
                        for (DebuggerSession session : modifiedClasses.keySet()) {
                            session.setModifiedClassesScanRequired(true);
                        }
                        callbackWrapper.onCancel(sessions);
                        return;
                    }
                    HashSet<DebuggerSession> toReload = new HashSet<DebuggerSession>(dialog.getSessionsToReload());
                    for (DebuggerSession session : modifiedClasses.keySet()) {
                        if (toReload.contains(session)) continue;
                        session.setModifiedClassesScanRequired(true);
                    }
                    modifiedClasses.keySet().retainAll(toReload);
                } else if (shouldDisplayHangWarning && (answer = Messages.showCheckboxMessageDialog((String)JavaDebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]), (String[])new String[]{"Perform &Reload Classes", "&Skip Reload Classes"}, (String)UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getWarningIcon(), (exitCode, cb) -> {
                    settings.HOTSWAP_HANG_WARNING_ENABLED = !cb.isSelected();
                    return exitCode == 0 ? exitCode : 1;
                })) == 1) {
                    for (DebuggerSession session : modifiedClasses.keySet()) {
                        session.setModifiedClassesScanRequired(true);
                    }
                    callbackWrapper.onCancel(sessions);
                    return;
                }
                if (!modifiedClasses.isEmpty()) {
                    final HotSwapProgressImpl progress = new HotSwapProgressImpl(this.myProject);
                    if (modifiedClasses.keySet().size() == 1) {
                        progress.setSessionForActions((DebuggerSession)ContainerUtil.getFirstItem(modifiedClasses.keySet()));
                    }
                    progress.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener(){

                        @Override
                        public void onCancel() {
                            callbackWrapper.onCancel(sessions);
                        }

                        @Override
                        public void onFinish() {
                            if (progress.getMessages(4).isEmpty()) {
                                callbackWrapper.onSuccess(sessions);
                            } else {
                                callbackWrapper.onFailure(sessions);
                            }
                        }
                    });
                    application.executeOnPooledThread(() -> HotSwapUIImpl.reloadModifiedClasses(modifiedClasses, progress));
                }
            }, ModalityState.NON_MODAL);
        });
    }

    @NotNull
    private HotSwapProgressImpl createHotSwapProgress(final @NotNull HotSwapStatusListener callbackWrapper, final @NotNull List<DebuggerSession> sessions) {
        HotSwapProgressImpl progress = new HotSwapProgressImpl(this.myProject);
        progress.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener(){

            @Override
            public void onCancel() {
                callbackWrapper.onCancel(sessions);
            }
        });
        return progress;
    }

    @NotNull
    private static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClassesWithProgress(@NotNull List<DebuggerSession> sessions, @NotNull HotSwapProgressImpl progress) {
        return HotSwapUIImpl.scanForModifiedClassesWithProgress(sessions, null, progress);
    }

    @NotNull
    private static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClassesWithProgress(@NotNull List<DebuggerSession> sessions, @Nullable NotNullLazyValue<? extends List<String>> outputPaths, @NotNull HotSwapProgressImpl progress) {
        return (Map)ProgressManager.getInstance().runProcess(() -> {
            try {
                Map<DebuggerSession, Map<String, HotSwapFile>> map2 = HotSwapManager.scanForModifiedClasses(sessions, outputPaths, progress);
                return map2;
            }
            finally {
                progress.finished();
            }
        }, progress.getProgressIndicator());
    }

    private static void reloadModifiedClasses(Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, HotSwapProgressImpl progress) {
        ProgressManager.getInstance().runProcess(() -> {
            HotSwapManager.reloadModifiedClasses(modifiedClasses, progress);
            progress.finished();
        }, progress.getProgressIndicator());
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession session, boolean compileBeforeHotswap) {
        this.reloadChangedClasses(session, compileBeforeHotswap, null);
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession session, boolean compileBeforeHotswap, @Nullable HotSwapStatusListener callback) {
        this.dontAskHotswapAfterThisCompilation();
        if (compileBeforeHotswap) {
            ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)session.getProject());
            if (callback == null) {
                projectTaskManager.buildAllModules();
            } else {
                ProjectTask buildProjectTask = projectTaskManager.createAllModulesBuildTask(true, session.getProject());
                ProjectTaskContext context = new ProjectTaskContext((Object)callback).withUserData(HOT_SWAP_CALLBACK_KEY, (Object)callback);
                projectTaskManager.run(context, buildProjectTask);
            }
        } else if (session.isAttached()) {
            this.hotSwapSessions(Collections.singletonList(session), callback);
        } else if (callback != null) {
            callback.onFailure((List<DebuggerSession>)new SmartList((Object)session));
        }
    }

    @Override
    public void compileAndReload(@NotNull DebuggerSession session, VirtualFile ... files) {
        this.dontAskHotswapAfterThisCompilation();
        ProjectTaskManager.getInstance((Project)session.getProject()).compile(files);
    }

    public void dontAskHotswapAfterThisCompilation() {
        this.myAskBeforeHotswap = false;
    }

    public static boolean canHotSwap(@NotNull DebuggerSession debuggerSession) {
        return debuggerSession.isAttached() && debuggerSession.getProcess().canRedefineClasses();
    }

    @NotNull
    private static List<DebuggerSession> getHotSwappableDebugSessions(Project project) {
        return (List)DebuggerManagerEx.getInstanceEx(project).getSessions().stream().filter(HotSwapUIImpl::canHotSwap).collect(Collectors.toCollection(SmartList::new));
    }

    public static class HotSwapDebuggerManagerListener
    implements DebuggerManagerListener {
        @NotNull
        private final Project myProject;
        private MessageBusConnection myConn;

        public HotSwapDebuggerManagerListener(@NotNull Project project) {
            this.myProject = project;
            this.myConn = null;
        }

        @Override
        public void sessionAttached(DebuggerSession session) {
            if (this.myConn == null) {
                this.myConn = this.myProject.getMessageBus().connect();
                this.myConn.subscribe(ProjectTaskListener.TOPIC, (Object)new MyCompilationStatusListener(this.myProject));
            }
        }

        @Override
        public void sessionDetached(DebuggerSession session) {
            if (!HotSwapUIImpl.getHotSwappableDebugSessions(this.myProject).isEmpty()) {
                return;
            }
            MessageBusConnection conn = this.myConn;
            if (conn != null) {
                Disposer.dispose((Disposable)conn);
                this.myConn = null;
            }
        }
    }

    private static class MyCompilationStatusListener
    implements ProjectTaskListener {
        private final THashSet<File> myOutputRoots;
        private final Project myProject;

        private MyCompilationStatusListener(Project project) {
            this.myProject = project;
            this.myOutputRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (String path : CompilerPaths.getOutputPaths((Module[])ModuleManager.getInstance((Project)this.myProject).getModules())) {
                this.myOutputRoots.add((Object)new File(path));
            }
        }

        public void started(@NotNull ProjectTaskContext context) {
            context.enableCollectionOfGeneratedFiles();
        }

        public void finished(@NotNull ProjectTaskManager.Result result) {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (!MyCompilationStatusListener.hasCompilationResults(result)) {
                return;
            }
            ProjectTaskContext context = result.getContext();
            if (!(result.hasErrors() || result.isAborted() || ((Boolean)SKIP_HOT_SWAP_KEY.getRequired((UserDataHolder)context)).booleanValue())) {
                HotSwapUIImpl instance = (HotSwapUIImpl)HotSwapUI.getInstance(this.myProject);
                for (HotSwapVetoableListener listener : instance.myListeners) {
                    if (listener.shouldHotSwap(context)) continue;
                    return;
                }
                List sessions = HotSwapUIImpl.getHotSwappableDebugSessions(this.myProject);
                if (!sessions.isEmpty()) {
                    Map<String, Collection> generatedPaths;
                    Collection generatedFilesRoots = context.getGeneratedFilesRoots();
                    if (!generatedFilesRoots.isEmpty()) {
                        generatedPaths = new HashMap();
                        for (String outputRoot : generatedFilesRoots) {
                            Collection relativePaths;
                            if (!JpsPathUtil.isUnder(this.myOutputRoots, (File)new File(outputRoot)) || (relativePaths = (Collection)context.getGeneratedFilesRelativePaths(outputRoot).stream().filter(relativePath -> StringUtil.endsWith((CharSequence)relativePath, (CharSequence)".class")).collect(Collectors.toCollection(SmartList::new))).isEmpty()) continue;
                            generatedPaths.put(outputRoot, relativePaths);
                        }
                    } else {
                        generatedPaths = Collections.emptyMap();
                    }
                    HotSwapStatusListener callback = (HotSwapStatusListener)context.getUserData(HOT_SWAP_CALLBACK_KEY);
                    NotNullLazyValue outputRoots = context.getDirtyOutputPaths().map(stream -> NotNullLazyValue.createValue(() -> stream.collect(Collectors.toCollection(SmartList::new)))).orElse(null);
                    instance.hotSwapSessions(sessions, generatedPaths, (NotNullLazyValue<? extends List<String>>)outputRoots, callback);
                }
            }
        }

        private static boolean hasCompilationResults(@NotNull ProjectTaskManager.Result result) {
            return result.anyTaskMatches((task, state) -> task instanceof ModuleBuildTask && !state.isFailed() && !state.isSkipped());
        }
    }
}

