/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JavaValuePresentation;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.debugger.ui.tree.render.XValuePresentationProvider;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.InternalIterator;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.function.BiConsumer;
import org.jdom.Element;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeRendererSettings", storages={@Storage(value="debugger.xml"), @Storage(value="debugger.renderers.xml", deprecated=true)})
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(NodeRendererSettings.class);
    @NonNls
    private static final String REFERENCE_RENDERER = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String RENDERER_ID = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> myDispatcher = EventDispatcher.create(NodeRendererSettingsListener.class);
    private final RendererConfiguration myCustomRenderers = new RendererConfiguration(this);
    private static final String USE_ANDROID_RENDERER = "use.android.renderer";
    private boolean myUseAndroidRenderer = PropertiesComponent.getInstance().getBoolean("use.android.renderer", false);
    private final PrimitiveRenderer myPrimitiveRenderer = new PrimitiveRenderer();
    private final ArrayRenderer myArrayRenderer = new ArrayRenderer();
    private final ClassRenderer myClassRenderer = new ClassRenderer();
    private final HexRenderer myHexRenderer = new HexRenderer();
    private final ToStringRenderer myToStringRenderer = new ToStringRenderer();
    private final NodeRenderer[] myAlternateCollectionRenderers = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), NodeRendererSettings.createExpressionArrayChildrenRenderer("entrySet().toArray()", "!isEmpty()", this.myArrayRenderer)), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", new MapEntryLabelRenderer(), NodeRendererSettings.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), new ListObjectRenderer(this, this.myArrayRenderer), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), NodeRendererSettings.createExpressionArrayChildrenRenderer("toArray()", "!isEmpty()", this.myArrayRenderer))};
    @NonNls
    private static final String HEX_VIEW_ENABLED = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String ALTERNATIVE_COLLECTION_VIEW_ENABLED = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String CUSTOM_RENDERERS_TAG_NAME = "CustomRenderers";

    public NodeRendererSettings() {
        this.myHexRenderer.setEnabled(false);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ServiceManager.getService(NodeRendererSettings.class);
    }

    public void setAlternateCollectionViewsEnabled(boolean enabled) {
        for (NodeRenderer myAlternateCollectionRenderer : this.myAlternateCollectionRenderers) {
            myAlternateCollectionRenderer.setEnabled(enabled);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.myAlternateCollectionRenderers[0].isEnabled();
    }

    void setUseAndroidRenderer(boolean en) {
        this.myUseAndroidRenderer = en;
        PropertiesComponent.getInstance().setValue(USE_ANDROID_RENDERER, Boolean.toString(en));
    }

    boolean isUsingAndroidRenderer() {
        return this.myUseAndroidRenderer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeRendererSettings)) {
            return false;
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)o).getState());
    }

    public void addListener(NodeRendererSettingsListener listener, Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener, disposable);
    }

    public Element getState() {
        Element element = new Element("state");
        if (this.myHexRenderer.isEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)HEX_VIEW_ENABLED, (String)"true");
        }
        if (!this.areAlternateCollectionViewsEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED, (String)"false");
        }
        try {
            this.addRendererIfNotDefault(this.myToStringRenderer, element);
            this.addRendererIfNotDefault(this.myClassRenderer, element);
            this.addRendererIfNotDefault(this.myPrimitiveRenderer, element);
            if (this.myCustomRenderers.getRendererCount() > 0) {
                Element custom = new Element(CUSTOM_RENDERERS_TAG_NAME);
                element.addContent(custom);
                this.myCustomRenderers.writeExternal(custom);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    private void addRendererIfNotDefault(@NotNull Renderer renderer, @NotNull Element to) {
        Element element = this.writeRenderer(renderer);
        if (element.getContentSize() == 0 && element.getAttributes().size() <= 1) {
            return;
        }
        to.addContent(element);
    }

    public void loadState(@NotNull Element root) {
        String alternativeEnabled;
        String hexEnabled = JDOMExternalizerUtil.readField((Element)root, (String)HEX_VIEW_ENABLED);
        if (hexEnabled != null) {
            this.myHexRenderer.setEnabled(Boolean.parseBoolean(hexEnabled));
        }
        if ((alternativeEnabled = JDOMExternalizerUtil.readField((Element)root, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED)) != null) {
            this.setAlternateCollectionViewsEnabled(Boolean.parseBoolean(alternativeEnabled));
        }
        for (Element elem : root.getChildren(RENDERER_TAG)) {
            String id = elem.getAttributeValue(RENDERER_ID);
            if (id == null) continue;
            try {
                if ("ToStringRenderer".equals(id)) {
                    this.myToStringRenderer.readExternal(elem);
                    if (this.myToStringRenderer.isEnabled()) continue;
                    this.myToStringRenderer.setEnabled(true);
                    this.myToStringRenderer.setOnDemand(true);
                    continue;
                }
                if ("ClassRenderer".equals(id)) {
                    this.myClassRenderer.readExternal(elem);
                    continue;
                }
                if (!"PrimitiveRenderer".equals(id)) continue;
                this.myPrimitiveRenderer.readExternal(elem);
            }
            catch (InvalidDataException invalidDataException) {}
        }
        Element custom = root.getChild(CUSTOM_RENDERERS_TAG_NAME);
        if (custom != null) {
            this.myCustomRenderers.readExternal(custom);
        }
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.myCustomRenderers;
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.myPrimitiveRenderer;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.myArrayRenderer;
    }

    public ClassRenderer getClassRenderer() {
        return this.myClassRenderer;
    }

    public HexRenderer getHexRenderer() {
        return this.myHexRenderer;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.myToStringRenderer;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.myAlternateCollectionRenderers;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers(Project project) {
        ArrayList<NodeRenderer> allRenderers = new ArrayList<NodeRenderer>();
        this.myCustomRenderers.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)renderer -> {
            allRenderers.add((NodeRenderer)renderer);
            return true;
        }));
        if (Registry.is((String)"debugger.renderers.annotations")) {
            ReadAction.run(() -> this.addAnnotationRenderers(allRenderers, project));
        }
        CompoundRendererProvider.EP_NAME.extensions().map(CompoundRendererProvider::createRenderer).forEach(allRenderers::add);
        allRenderers.addAll(NodeRenderer.EP_NAME.getExtensionList());
        allRenderers.add(this.myHexRenderer);
        allRenderers.add(this.myPrimitiveRenderer);
        Collections.addAll(allRenderers, this.myAlternateCollectionRenderers);
        allRenderers.add(this.myToStringRenderer);
        allRenderers.add(this.myArrayRenderer);
        allRenderers.add(this.myClassRenderer);
        if (!this.myUseAndroidRenderer) {
            int androidIndex = -1;
            for (int i = 0; i < allRenderers.size(); ++i) {
                if (!"android.resource.renderer".equals(((NodeRenderer)allRenderers.get(i)).getUniqueId())) continue;
                androidIndex = i;
                break;
            }
            if (androidIndex != -1) {
                NodeRenderer androidRenderer = (NodeRenderer)allRenderers.remove(androidIndex);
                allRenderers.add(androidRenderer);
            }
        }
        return allRenderers;
    }

    private void addAnnotationRenderers(List<NodeRenderer> renderers, Project project) {
        try {
            NodeRendererSettings.visitAnnotatedElements(Debug.Renderer.class.getName().replace("$", "."), project, (e, annotation) -> {
                if (e instanceof PsiClass) {
                    String text2 = NodeRendererSettings.getAttributeValue(annotation, "text");
                    LabelRenderer labelRenderer = StringUtil.isEmpty((String)text2) ? null : NodeRendererSettings.createLabelRenderer(null, text2, null);
                    String childrenArray = NodeRendererSettings.getAttributeValue(annotation, "childrenArray");
                    String isLeaf = NodeRendererSettings.getAttributeValue(annotation, "hasChildren");
                    ExpressionChildrenRenderer childrenRenderer = StringUtil.isEmpty((String)childrenArray) ? null : NodeRendererSettings.createExpressionArrayChildrenRenderer(childrenArray, isLeaf, this.myArrayRenderer);
                    PsiClass cls = (PsiClass)e;
                    CompoundReferenceRenderer renderer = this.createCompoundReferenceRenderer(cls.getQualifiedName(), cls.getQualifiedName(), labelRenderer, childrenRenderer);
                    renderer.setEnabled(true);
                    renderers.add(renderer);
                }
            });
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
    }

    private static String getAttributeValue(PsiAnnotation annotation, String attribute) {
        PsiAnnotationMemberValue value2 = annotation.findAttributeValue(attribute);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof PsiLiteralValue) {
            return String.valueOf(((PsiLiteralValue)value2).getValue());
        }
        throw new IllegalStateException("String literal expected, but was " + value2);
    }

    public Renderer readRenderer(Element root) throws InvalidDataException {
        if (root == null) {
            return null;
        }
        if (!RENDERER_TAG.equals(root.getName())) {
            throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
        }
        String rendererId = root.getAttributeValue(RENDERER_ID);
        if (rendererId == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        Renderer renderer = this.createRenderer(rendererId);
        if (renderer == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        renderer.readExternal(root);
        return renderer;
    }

    @NotNull
    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        Element root = new Element(RENDERER_TAG);
        if (renderer != null) {
            root.setAttribute(RENDERER_ID, renderer.getUniqueId());
            renderer.writeExternal(root);
        }
        return root;
    }

    public Renderer createRenderer(String rendererId) {
        if ("ClassRenderer".equals(rendererId)) {
            return this.myClassRenderer;
        }
        if ("ArrayRenderer".equals(rendererId)) {
            return this.myArrayRenderer;
        }
        if ("PrimitiveRenderer".equals(rendererId)) {
            return this.myPrimitiveRenderer;
        }
        if ("HexRenderer".equals(rendererId)) {
            return this.myHexRenderer;
        }
        if (rendererId.equals("ExpressionChildrenRenderer")) {
            return new ExpressionChildrenRenderer();
        }
        if (rendererId.equals("LabelRenderer")) {
            return new LabelRenderer();
        }
        if (rendererId.equals("EnumerationChildrenRenderer")) {
            return new EnumerationChildrenRenderer();
        }
        if (rendererId.equals("ToStringRenderer")) {
            return this.myToStringRenderer;
        }
        if (rendererId.equals("CompoundNodeRenderer") || rendererId.equals("CompoundTypeRenderer") || rendererId.equals(REFERENCE_RENDERER)) {
            return this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
        }
        return null;
    }

    public CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String rendererName, @NonNls String className2, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer renderer = new CompoundReferenceRenderer(this, rendererName, labelRenderer, childrenRenderer);
        renderer.setClassName(className2);
        renderer.setIsApplicableChecker(type2 -> DebuggerUtilsAsync.instanceOf(type2, renderer.getClassName()));
        return renderer;
    }

    private static ExpressionChildrenRenderer createExpressionArrayChildrenRenderer(String expressionText, String childrenExpandableText, ArrayRenderer arrayRenderer) {
        ExpressionChildrenRenderer renderer = NodeRendererSettings.createExpressionChildrenRenderer(expressionText, childrenExpandableText);
        renderer.setPredictedRenderer(arrayRenderer);
        return renderer;
    }

    public static ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String expressionText, @NonNls String childrenExpandableText) {
        ExpressionChildrenRenderer childrenRenderer = new ExpressionChildrenRenderer();
        childrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)JavaFileType.INSTANCE));
        if (childrenExpandableText != null) {
            childrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, childrenExpandableText, "", (FileType)JavaFileType.INSTANCE));
        }
        return childrenRenderer;
    }

    public static EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] expressions2) {
        EnumerationChildrenRenderer childrenRenderer = new EnumerationChildrenRenderer();
        if (expressions2 != null && expressions2.length > 0) {
            ArrayList<EnumerationChildrenRenderer.ChildInfo> childrenList = new ArrayList<EnumerationChildrenRenderer.ChildInfo>(expressions2.length);
            for (String[] expression2 : expressions2) {
                childrenList.add(new EnumerationChildrenRenderer.ChildInfo(expression2[0], new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression2[1], "", (FileType)JavaFileType.INSTANCE), false));
            }
            childrenRenderer.setChildren(childrenList);
        }
        return childrenRenderer;
    }

    private static LabelRenderer createLabelRenderer(final @NonNls String prefix, @NonNls String expressionText, final @NonNls String postfix) {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                String evaluated = super.calcLabel(descriptor, evaluationContext, labelListener);
                if (prefix == null && postfix == null) {
                    return evaluated;
                }
                if (prefix != null && postfix != null) {
                    return prefix + evaluated + postfix;
                }
                if (prefix != null) {
                    return prefix + evaluated;
                }
                return evaluated + postfix;
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)JavaFileType.INSTANCE));
        return labelRenderer;
    }

    static void visitAnnotatedElements(String annotationFqn, Project project, BiConsumer<PsiModifierListOwner, PsiAnnotation> consumer) {
        JavaAnnotationIndex.getInstance().get(StringUtil.getShortName((String)annotationFqn), project, GlobalSearchScope.allScope((Project)project)).forEach(annotation -> {
            PsiElement owner2;
            PsiElement parent = annotation.getContext();
            if (annotationFqn.equals(annotation.getQualifiedName()) && parent instanceof PsiModifierList && (owner2 = parent.getParent()) instanceof PsiModifierListOwner) {
                consumer.accept((PsiModifierListOwner)owner2, (PsiAnnotation)annotation);
            }
        });
    }

    private static class ListObjectRenderer
    extends CompoundReferenceRenderer {
        ListObjectRenderer(NodeRendererSettings rendererSettings, ArrayRenderer arrayRenderer) {
            super(rendererSettings, "List", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), NodeRendererSettings.createExpressionArrayChildrenRenderer("toArray()", "!isEmpty()", arrayRenderer));
            this.setClassName("java.util.List");
            this.setIsApplicableChecker(type2 -> DebuggerUtilsAsync.instanceOf(type2, this.getClassName()));
        }

        @Override
        public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
            LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl);
            try {
                return this.getChildValueExpression("this.get(" + ((ArrayElementDescriptorImpl)node.getDescriptor()).getIndex() + ")", node, context);
            }
            catch (IncorrectOperationException e) {
                return super.getChildValueExpression(node, context);
            }
        }
    }

    private static class MapEntryLabelRenderer
    extends ReferenceRenderer
    implements ValueLabelRenderer,
    XValuePresentationProvider,
    OnDemandRenderer {
        private static final Key<ValueDescriptorImpl> KEY_DESCRIPTOR = Key.create((String)"KEY_DESCRIPTOR");
        private static final Key<ValueDescriptorImpl> VALUE_DESCRIPTOR = Key.create((String)"VALUE_DESCRIPTOR");
        private final MyCachedEvaluator myKeyExpression = new MyCachedEvaluator();
        private final MyCachedEvaluator myValueExpression = new MyCachedEvaluator();

        private MapEntryLabelRenderer() {
            super("java.util.Map$Entry");
            this.myKeyExpression.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getKey()", "", (FileType)JavaFileType.INSTANCE));
            this.myValueExpression.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getValue()", "", (FileType)JavaFileType.INSTANCE));
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
            if (!this.isShowValue(descriptor, evaluationContext)) {
                return "";
            }
            String keyText = this.calcExpression(evaluationContext, descriptor, this.myKeyExpression, listener, KEY_DESCRIPTOR);
            String valueText = this.calcExpression(evaluationContext, descriptor, this.myValueExpression, listener, VALUE_DESCRIPTOR);
            return keyText + " -> " + valueText;
        }

        private String calcExpression(EvaluationContext evaluationContext, ValueDescriptor descriptor, MyCachedEvaluator evaluator, DescriptorLabelListener listener, Key<ValueDescriptorImpl> key2) throws EvaluateException {
            Value eval = this.doEval(evaluationContext, descriptor.getValue(), evaluator);
            if (eval != null) {
                WatchItemDescriptor evalDescriptor = new WatchItemDescriptor(evaluationContext.getProject(), evaluator.getReferenceExpression(), eval, (EvaluationContextImpl)evaluationContext){

                    @Override
                    public void updateRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
                        this.updateRepresentationNoNotify(context, labelListener);
                    }
                };
                evalDescriptor.updateRepresentation((EvaluationContextImpl)evaluationContext, listener);
                descriptor.putUserData(key2, evalDescriptor);
                return evalDescriptor.getValueLabel();
            }
            descriptor.putUserData(key2, null);
            return "null";
        }

        @Override
        public String getUniqueId() {
            return "MapEntry renderer";
        }

        @Override
        @NotNull
        public String getLinkText() {
            return JavaDebuggerBundle.message((String)"message.node.evaluate", (Object[])new Object[0]);
        }

        private Value doEval(EvaluationContext evaluationContext, Value originalValue, MyCachedEvaluator cachedEvaluator) throws EvaluateException {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            if (originalValue == null) {
                return null;
            }
            try {
                ExpressionEvaluator evaluator = cachedEvaluator.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext thisEvaluationContext = evaluationContext.createEvaluationContext(originalValue);
                return evaluator.evaluate(thisEvaluationContext);
            }
            catch (EvaluateException ex) {
                throw new EvaluateException(JavaDebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        @NotNull
        public XValuePresentation getPresentation(ValueDescriptorImpl descriptor) {
            final boolean inCollection = descriptor instanceof ArrayElementDescriptor;
            return new JavaValuePresentation(descriptor){

                @Override
                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
                    this.renderDescriptor((Key<ValueDescriptorImpl>)KEY_DESCRIPTOR, renderer, node);
                    renderer.renderComment(" -> ");
                    this.renderDescriptor((Key<ValueDescriptorImpl>)VALUE_DESCRIPTOR, renderer, node);
                }

                private void renderDescriptor(Key<ValueDescriptorImpl> key2, @NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
                    ValueDescriptorImpl valueDescriptor = this.myValueDescriptor.getUserData(key2);
                    if (valueDescriptor != null) {
                        String type2 = valueDescriptor.getIdLabel();
                        if (inCollection && type2 != null) {
                            renderer.renderComment("{" + type2 + "} ");
                        }
                        new JavaValuePresentation(valueDescriptor).renderValue(renderer, node);
                    } else {
                        renderer.renderValue("null");
                    }
                }

                @Override
                @NotNull
                public String getSeparator() {
                    return inCollection ? "" : super.getSeparator();
                }

                public boolean isShowName() {
                    return !inCollection;
                }

                @Override
                @Nullable
                public String getType() {
                    return inCollection ? null : super.getType();
                }
            };
        }

        private class MyCachedEvaluator
        extends CachedEvaluator {
            private MyCachedEvaluator() {
            }

            @Override
            protected String getClassName() {
                return MapEntryLabelRenderer.this.getClassName();
            }

            @Override
            public ExpressionEvaluator getEvaluator(Project project) throws EvaluateException {
                return super.getEvaluator(project);
            }
        }
    }
}

