/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTask;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.ExpressionEditorWithHistory;
import com.intellij.debugger.memory.ui.FilteringProgressView;
import com.intellij.debugger.memory.ui.InstancesWithStackFrameView;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.intellij.xdebugger.memory.ui.InstancesViewBase;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.sun.jdi.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class InstancesView
extends InstancesViewBase {
    private static final Logger LOG = Logger.getInstance(InstancesView.class);
    private static final int MAX_TREE_NODE_COUNT = 2000;
    private static final int FILTERING_CHUNK_SIZE = 50;
    private static final int FILTERING_BUTTON_ADDITIONAL_WIDTH = 30;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final int DEFAULT_INSTANCES_LIMIT = 500000;
    private static final int MAX_DURATION_TO_UPDATE_TREE_SECONDS = 3;
    private static final int FILTERING_PROGRESS_UPDATING_MIN_DELAY_MILLIS = 17;
    private final InstancesTree myInstancesTree;
    private final XDebuggerExpressionEditor myFilterConditionEditor;
    private final MyNodeManager myNodeManager;
    private final Consumer<? super String> myWarningMessageConsumer;
    private final JButton myFilterButton = new JButton(CommonBundle.message((String)"button.filter", (Object[])new Object[0]));
    private final FilteringProgressView myProgress = new FilteringProgressView();
    private final Object myFilteringTaskLock = new Object();
    private boolean myIsAndroidVM;
    private final DebugProcessImpl myDebugProcess;
    private final String myClassName;
    private volatile FilteringTask myFilteringTask;
    private volatile Future<?> myFilteringTaskFuture;

    InstancesView(@NotNull XDebugSession session, InstancesProvider instancesProvider, String className2, Consumer<? super String> warningMessageConsumer) {
        super((LayoutManager)new BorderLayout(0, JBUIScale.scale((int)5)), session, instancesProvider);
        this.myClassName = className2;
        this.myDebugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)session.getProject()).getDebugProcess(session.getDebugProcess().getProcessHandler());
        this.myNodeManager = new MyNodeManager(session.getProject());
        this.myWarningMessageConsumer = warningMessageConsumer;
        XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        this.myFilterConditionEditor = new ExpressionEditorWithHistory(session.getProject(), className2, editorsProvider, (Disposable)this);
        Dimension filteringButtonSize = this.myFilterConditionEditor.getEditorComponent().getPreferredSize();
        filteringButtonSize.width = JBUIScale.scale((int)30) + this.getFilterButton().getPreferredSize().width;
        this.getFilterButton().setPreferredSize(filteringButtonSize);
        JBPanel filteringPane = new JBPanel((LayoutManager)new BorderLayout(JBUIScale.scale((int)5), 0));
        JBLabel sideEffectsWarning = new JBLabel(JavaDebuggerBundle.message((String)"warning.filtering.may.have.side.effects", (Object[])new Object[0]), 4);
        sideEffectsWarning.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        sideEffectsWarning.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        sideEffectsWarning.setFontColor(UIUtil.FontColor.BRIGHTER);
        filteringPane.add((Component)new JBLabel(JavaDebuggerBundle.message((String)"condition", (Object[])new Object[0])), (Object)"West");
        filteringPane.add((Component)this.myFilterConditionEditor.getComponent(), (Object)"Center");
        filteringPane.add((Component)this.getFilterButton(), (Object)"East");
        filteringPane.add((Component)sideEffectsWarning, (Object)"South");
        this.getProgress().addStopActionListener(this::cancelFilteringTask);
        this.myInstancesTree = new InstancesTree(session.getProject(), editorsProvider, this.getValueMarkers(session), this::updateInstances);
        this.getFilterButton().addActionListener(e -> {
            String expression2 = this.myFilterConditionEditor.getExpression().getExpression();
            if (!expression2.isEmpty()) {
                this.myFilterConditionEditor.saveTextInHistory();
            }
            this.getFilterButton().setEnabled(false);
            this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
        });
        final StackFrameList list = new StackFrameList(this.myDebugProcess);
        list.addListSelectionListener(e -> list.navigateToSelectedValue(false));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                list.navigateToSelectedValue(true);
                return true;
            }
        }.installOn((Component)((Object)list));
        InstancesWithStackFrameView instancesWithStackFrame = new InstancesWithStackFrameView(session, this.myInstancesTree, list, className2);
        this.add((Component)filteringPane, "North");
        this.add(instancesWithStackFrame.getComponent(), "Center");
        JComponent focusedComponent = this.myFilterConditionEditor.getEditorComponent();
        UiNotifyConnector.doWhenFirstShown((JComponent)focusedComponent, () -> IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, true));
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.cancelFilteringTask());
            }

            public void sessionResumed() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().setVisible(true));
            }
        });
    }

    protected InstancesTree getInstancesTree() {
        return this.myInstancesTree;
    }

    public void dispose() {
        this.cancelFilteringTask();
        Disposer.dispose((Disposable)this.myInstancesTree);
    }

    private void updateInstances() {
        this.cancelFilteringTask();
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOWEST;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                InstancesView.this.myIsAndroidVM = DebuggerUtils.isAndroidVM((VirtualMachine)InstancesView.this.myDebugProcess.getVirtualMachineProxy().getVirtualMachine());
                int limit = InstancesView.this.myIsAndroidVM ? 30000 : 500000;
                List<JavaReferenceInfo> instances = ContainerUtil.map((Collection)InstancesView.this.getInstancesProvider().getInstances(limit + 1), referenceInfo -> (JavaReferenceInfo)referenceInfo);
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                if (instances.size() > limit) {
                    InstancesView.this.myWarningMessageConsumer.accept(String.format("Not all instances will be loaded (only %d)", limit));
                    instances = instances.subList(0, limit);
                }
                if (Registry.is((String)"debugger.memory.agent.use.in.memory.view")) {
                    instances = MemoryAgentUtil.tryCalculateSizes(evaluationContext, instances);
                }
                Object object = InstancesView.this.myFilteringTaskLock;
                synchronized (object) {
                    List<JavaReferenceInfo> finalInstances = instances;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        InstancesView.this.myFilteringTask = new FilteringTask(InstancesView.this.myClassName, InstancesView.this.myDebugProcess, InstancesView.this.myFilterConditionEditor.getExpression(), new MyValuesList(finalInstances), new MyFilteringCallback(evaluationContext));
                        InstancesView.this.myFilteringTaskFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)InstancesView.this.myFilteringTask);
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFilteringTask() {
        if (this.myFilteringTask != null) {
            Object object = this.myFilteringTaskLock;
            synchronized (object) {
                if (this.myFilteringTask != null) {
                    this.myFilteringTask.cancel();
                    this.myFilteringTask = null;
                    this.myFilteringTaskFuture.cancel(false);
                    this.myFilteringTaskFuture = null;
                }
            }
        }
    }

    public JButton getFilterButton() {
        return this.myFilterButton;
    }

    public FilteringProgressView getProgress() {
        return this.myProgress;
    }

    private static class MyValuesList
    implements FilteringTask.ValuesList {
        private final List<? extends JavaReferenceInfo> myRefs;

        MyValuesList(List<? extends JavaReferenceInfo> refs) {
            this.myRefs = refs;
        }

        @Override
        public int size() {
            return this.myRefs.size();
        }

        @Override
        public JavaReferenceInfo get(int index) {
            return this.myRefs.get(index);
        }
    }

    private class MyFilteringCallback
    implements FilteringTaskCallback {
        private final ErrorsValueGroup myErrorsGroup = new ErrorsValueGroup();
        private final EvaluationContextImpl myEvaluationContext;
        private long myFilteringStartedTime;
        private int myProceedCount;
        private int myMatchedCount;
        private int myErrorsCount;
        private long myLastTreeUpdatingTime;
        private long myLastProgressUpdatingTime;
        private XValueChildrenList myChildren = new XValueChildrenList();

        MyFilteringCallback(EvaluationContextImpl evaluationContext) {
            this.myEvaluationContext = evaluationContext;
        }

        @Override
        public void started(int total) {
            this.myLastTreeUpdatingTime = this.myFilteringStartedTime = System.nanoTime();
            this.myLastProgressUpdatingTime = System.nanoTime();
            ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().start(total));
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action matched(@NotNull JavaReferenceInfo ref) {
            InstanceJavaValue val = new InstanceJavaValue(ref.createDescriptor(InstancesView.this.myDebugProcess.getProject()), this.myEvaluationContext, InstancesView.this.myNodeManager);
            ++this.myMatchedCount;
            ++this.myProceedCount;
            this.myChildren.add((XNamedValue)val);
            this.updateProgress();
            this.updateTree();
            return this.myMatchedCount < 2000 ? FilteringTaskCallback.Action.CONTINUE : FilteringTaskCallback.Action.STOP;
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action notMatched(@NotNull JavaReferenceInfo ref) {
            ++this.myProceedCount;
            this.updateProgress();
            return FilteringTaskCallback.Action.CONTINUE;
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action error(@NotNull JavaReferenceInfo ref, @NotNull String description) {
            InstanceJavaValue val = new InstanceJavaValue(ref.createDescriptor(InstancesView.this.myDebugProcess.getProject()), this.myEvaluationContext, InstancesView.this.myNodeManager);
            this.myErrorsGroup.addErrorValue(description, val);
            ++this.myProceedCount;
            ++this.myErrorsCount;
            this.updateProgress();
            return FilteringTaskCallback.Action.CONTINUE;
        }

        @Override
        public void completed(@NotNull FilteringResult reason) {
            if (!this.myErrorsGroup.isEmpty()) {
                this.myChildren.addBottomGroup((XValueGroup)this.myErrorsGroup);
            }
            long duration = System.nanoTime() - this.myFilteringStartedTime;
            LOG.info(String.format("Filtering completed in %d ms for %d instances", TimeUnit.NANOSECONDS.toMillis(duration), this.myProceedCount));
            int proceed = this.myProceedCount;
            int matched = this.myMatchedCount;
            int errors = this.myErrorsCount;
            XValueChildrenList childrenList = this.myChildren;
            ApplicationManager.getApplication().invokeLater(() -> {
                InstancesView.this.getProgress().updateProgress(proceed, matched, errors);
                InstancesView.this.myInstancesTree.addChildren(childrenList, true);
                InstancesView.this.getFilterButton().setEnabled(true);
                InstancesView.this.getProgress().complete(reason);
            });
        }

        private void updateProgress() {
            long now = System.nanoTime();
            if (now - this.myLastProgressUpdatingTime > TimeUnit.MILLISECONDS.toNanos(17L)) {
                int proceed = this.myProceedCount;
                int matched = this.myMatchedCount;
                int errors = this.myErrorsCount;
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().updateProgress(proceed, matched, errors));
                this.myLastProgressUpdatingTime = now;
            }
        }

        private void updateTree() {
            long now = System.nanoTime();
            int newChildrenCount = this.myChildren.size();
            if (newChildrenCount >= 50 || newChildrenCount > 0 && now - this.myLastTreeUpdatingTime > TimeUnit.SECONDS.toNanos(3L)) {
                XValueChildrenList children = this.myChildren;
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.myInstancesTree.addChildren(children, false));
                this.myChildren = new XValueChildrenList();
                this.myLastTreeUpdatingTime = System.nanoTime();
            }
        }
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project) {
            super(project, null);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(String message2) {
            return new DebuggerTreeNodeImpl(null, new MessageDescriptor(message2));
        }
    }
}

