/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentOperations;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MemoryAgentImpl
implements MemoryAgent {
    static final MemoryAgent DISABLED = new MemoryAgentImpl(MemoryAgentCapabilities.DISABLED);
    private final MemoryAgentCapabilities myCapabilities;

    MemoryAgentImpl(@NotNull MemoryAgentCapabilities capabilities) {
        this.myCapabilities = capabilities;
    }

    @Override
    public long estimateObjectSize(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference) throws EvaluateException {
        if (!this.myCapabilities.canEstimateObjectSize()) {
            throw new UnsupportedOperationException("Memory agent can't estimate object size");
        }
        return MemoryAgentOperations.estimateObjectSize(evaluationContext, reference);
    }

    @Override
    public long[] estimateObjectsSizes(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ObjectReference> references) throws EvaluateException {
        if (!this.myCapabilities.canEstimateObjectsSizes()) {
            throw new UnsupportedOperationException("Memory agent can't estimate objects sizes");
        }
        return MemoryAgentOperations.estimateObjectsSizes(evaluationContext, references);
    }

    @Override
    @NotNull
    public ReferringObjectsInfo findReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, int limit) throws EvaluateException {
        if (!this.myCapabilities.canGetReferringObjects()) {
            throw new UnsupportedOperationException("Memory agent can't provide referring objects");
        }
        return MemoryAgentOperations.findReferringObjects(evaluationContext, reference, limit);
    }

    @Override
    @NotNull
    public MemoryAgentCapabilities capabilities() {
        return this.myCapabilities;
    }
}

