/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action.tracking;

import com.intellij.debugger.memory.action.ActionUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;

public class TrackInstancesToggleAction
extends ToggleAction {
    public void update(@NotNull AnActionEvent e) {
        ReferenceType selectedClass = ActionUtil.getSelectedClass(e);
        if (selectedClass instanceof ArrayType) {
            e.getPresentation().setEnabled(false);
        } else {
            super.update(e);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        ReferenceType selectedClass = ActionUtil.getSelectedClass(e);
        Project project = e.getProject();
        if (project != null && selectedClass != null && !project.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance((Project)project);
            return tracker.isTracked(selectedClass.name());
        }
        return false;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ReferenceType selectedClass = ActionUtil.getSelectedClass(e);
        Project project = e.getProject();
        if (selectedClass != null && project != null && !project.isDisposed()) {
            InstancesTracker tracker = InstancesTracker.getInstance((Project)project);
            boolean isAlreadyTracked = tracker.isTracked(selectedClass.name());
            if (isAlreadyTracked && !state) {
                tracker.remove(selectedClass.name());
            }
            if (!isAlreadyTracked && state) {
                tracker.add(selectedClass.name(), TrackingType.CREATION);
            }
        }
    }
}

