/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.Patches;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodBytecodeUtil {
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");

    private MethodBytecodeUtil() {
    }

    public static void visit(Method method, MethodVisitor methodVisitor, boolean withLineNumbers) {
        MethodBytecodeUtil.visit(method, method.bytecodes(), methodVisitor, withLineNumbers);
    }

    public static void visit(Method method, long maxOffset, MethodVisitor methodVisitor, boolean withLineNumbers) {
        if (maxOffset > 0L) {
            byte[] originalBytecodes;
            byte[] bytecodes = originalBytecodes = method.bytecodes();
            if (maxOffset < (long)originalBytecodes.length) {
                bytecodes = new byte[originalBytecodes.length];
                System.arraycopy(originalBytecodes, 0, bytecodes, 0, (int)maxOffset);
            }
            MethodBytecodeUtil.visit(method, bytecodes, methodVisitor, withLineNumbers);
        }
    }

    public static byte[] getConstantPool(ReferenceType type2) {
        if (Patches.JDK_BUG_ID_6822627) {
            try {
                return type2.constantPool();
            }
            catch (NullPointerException e) {
                ReflectionUtil.resetField((Object)type2, (String)"constantPoolInfoGotten");
                return type2.constantPool();
            }
        }
        return type2.constantPool();
    }

    private static void visit(final Method method, byte[] bytecodes, final MethodVisitor methodVisitor, boolean withLineNumbers) {
        ReferenceType type2 = method.declaringType();
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream((OutputStream)bytes);){
            MethodBytecodeUtil.writeClassHeader(dos, type2.constantPoolCount(), MethodBytecodeUtil.getConstantPool(type2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassReader reader = new ClassReader(bytes.getInternalBuffer(), 0, bytes.size());
        ClassWriter writer = new ClassWriter(reader, 0);
        String superName = null;
        String[] interfaces = null;
        if (type2 instanceof ClassType) {
            ClassType superClass = ((ClassType)type2).superclass();
            superName = superClass != null ? superClass.name() : null;
            interfaces = (String[])((ClassType)type2).interfaces().stream().map(ReferenceType::name).toArray(String[]::new);
        } else if (type2 instanceof InterfaceType) {
            interfaces = (String[])((InterfaceType)type2).superinterfaces().stream().map(ReferenceType::name).toArray(String[]::new);
        }
        writer.visit(52, 1, type2.name(), type2.signature(), superName, interfaces);
        Attribute bootstrapMethods = MethodBytecodeUtil.createBootstrapMethods(reader, writer);
        if (bootstrapMethods != null) {
            writer.visitAttribute(bootstrapMethods);
        }
        MethodVisitor mv = writer.visitMethod(1, method.name(), method.signature(), method.signature(), null);
        mv.visitAttribute(MethodBytecodeUtil.createCode(writer, method, bytecodes, withLineNumbers));
        new ClassReader(writer.toByteArray()).accept(new ClassVisitor(524288){

            public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                assert (name2.equals(method.name()));
                return methodVisitor;
            }
        }, 0);
    }

    private static void writeClassHeader(DataOutputStream dos, int constantPoolCount, byte[] constantPool) throws IOException {
        dos.writeInt(-889275714);
        dos.writeInt(52);
        dos.writeShort(constantPoolCount + 1);
        dos.write(constantPool);
        byte[] utfStr = "BootstrapMethods".getBytes(StandardCharsets.UTF_8);
        dos.writeByte(1);
        dos.writeShort(utfStr.length);
        dos.write(utfStr);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(1);
        dos.writeShort(constantPoolCount);
        dos.writeInt(0);
    }

    @Nullable
    private static Attribute createBootstrapMethods(ClassReader classReader, ClassWriter classWriter) {
        HashSet<Short> bootstrapMethods = new HashSet<Short>();
        block4: for (int i = 1; i < classReader.getItemCount(); ++i) {
            int index = classReader.getItem(i);
            int tag = classReader.readByte(index - 1);
            switch (tag) {
                case 5: 
                case 6: {
                    ++i;
                    continue block4;
                }
                case 18: {
                    bootstrapMethods.add(classReader.readShort(index));
                }
            }
        }
        if (!bootstrapMethods.isEmpty()) {
            int dummyRef = classWriter.newHandle(6, "DummyOwner", "DummyMethod", "", false);
            return MethodBytecodeUtil.createAttribute("BootstrapMethods", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dos -> {
                dos.writeShort(bootstrapMethods.size());
                for (int i = 0; i < bootstrapMethods.size(); ++i) {
                    dos.writeShort(dummyRef);
                    dos.writeShort(0);
                }
            }));
        }
        return null;
    }

    private static Attribute createCode(ClassWriter cw, Method method, byte[] bytecodes, boolean withLineNumbers) {
        return MethodBytecodeUtil.createAttribute("Code", (ThrowableConsumer<DataOutputStream, IOException>)((ThrowableConsumer)dos -> {
            List<Location> locations;
            dos.writeShort(0);
            dos.writeShort(0);
            dos.writeInt(bytecodes.length);
            dos.write(bytecodes);
            dos.writeShort(0);
            List<Location> list = locations = withLineNumbers ? DebuggerUtilsEx.allLineLocations(method) : null;
            if (!ContainerUtil.isEmpty(locations)) {
                dos.writeShort(1);
                dos.writeShort(cw.newUTF8("LineNumberTable"));
                dos.writeInt(2 * locations.size() + 2);
                dos.writeShort(locations.size());
                for (Location l : locations) {
                    dos.writeShort((short)l.codeIndex());
                    dos.writeShort(l.lineNumber());
                }
            } else {
                dos.writeShort(0);
            }
        }));
    }

    private static Attribute createAttribute(String name2, ThrowableConsumer<DataOutputStream, IOException> generator) {
        int end;
        int start;
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream((OutputStream)bytes);){
            MethodBytecodeUtil.writeClassHeader(dos, 0, ArrayUtil.EMPTY_BYTE_ARRAY);
            start = dos.size();
            generator.consume((Object)dos);
            end = dos.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final ClassReader reader = new ClassReader(bytes.getInternalBuffer(), 0, bytes.size());
        return new Attribute(name2){

            public Attribute read() {
                return this.read(reader, start, end - start, null, 0, null);
            }
        }.read();
    }

    public static Type getVarInstructionType(int opcode) {
        switch (opcode) {
            case 22: 
            case 55: {
                return Type.LONG_TYPE;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE_TYPE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT_TYPE;
            }
            case 21: 
            case 54: {
                return Type.INT_TYPE;
            }
        }
        return OBJECT_TYPE;
    }

    @Nullable
    public static Method getLambdaMethod(ReferenceType clsType, final @NotNull ClassesByNameProvider classesByName) {
        List applicableMethods;
        final Ref methodRef = Ref.create();
        if (DebuggerUtilsEx.isLambdaClassName(clsType.name()) && (applicableMethods = ContainerUtil.filter(clsType.methods(), m -> m.isPublic() && !m.isBridge())).size() == 1) {
            MethodBytecodeUtil.visit((Method)applicableMethods.get(0), new MethodVisitor(524288){

                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                    Method method;
                    ReferenceType cls = (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner2));
                    if (cls != null && (method = DebuggerUtils.findMethod((ReferenceType)cls, (String)name2, (String)desc)) != null) {
                        methodRef.setIfNull((Object)method);
                    }
                }
            }, false);
        }
        return (Method)methodRef.get();
    }

    @Nullable
    public static Method getBridgeTargetMethod(final Method method, final @NotNull ClassesByNameProvider classesByName) {
        final Ref methodRef = Ref.create();
        if (method.isBridge()) {
            MethodBytecodeUtil.visit(method, new MethodVisitor(524288){

                public void visitMethodInsn(int opcode, String owner2, String name2, String desc, boolean itf) {
                    Method method2;
                    if ("java/lang/AbstractMethodError".equals(owner2)) {
                        return;
                    }
                    ReferenceType declaringType = method.declaringType();
                    owner2 = owner2.replace("/", ".");
                    ReferenceType cls = declaringType.name().equals(owner2) ? declaringType : (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(owner2));
                    if (cls != null && (method2 = DebuggerUtils.findMethod((ReferenceType)cls, (String)name2, (String)desc)) != null) {
                        methodRef.setIfNull((Object)method2);
                    }
                }
            }, false);
        }
        return (Method)methodRef.get();
    }

    public static List<Location> removeSameLineLocations(@NotNull List<Location> locations) {
        if (locations.size() < 2) {
            return locations;
        }
        MultiMap byMethod = new MultiMap();
        for (Location location : locations) {
            byMethod.putValue((Object)location.method(), (Object)location);
        }
        ArrayList<Location> res = new ArrayList<Location>();
        for (Map.Entry entry : byMethod.entrySet()) {
            res.addAll(MethodBytecodeUtil.removeMethodSameLineLocations((Method)entry.getKey(), (List)entry.getValue()));
        }
        return res;
    }

    private static Collection<Location> removeMethodSameLineLocations(@NotNull Method method, @NotNull List<Location> locations) {
        int locationsSize = locations.size();
        if (locationsSize < 2) {
            return locations;
        }
        if (!method.declaringType().virtualMachine().canGetConstantPool()) {
            return locations;
        }
        final int lineNumber = locations.get(0).lineNumber();
        final ArrayList mask = new ArrayList(locationsSize);
        MethodBytecodeUtil.visit(method, new MethodVisitor(524288){
            boolean myNewBlock;
            {
                super(x0);
                this.myNewBlock = true;
            }

            public void visitLineNumber(int line, Label start) {
                if (lineNumber == line) {
                    mask.add(this.myNewBlock);
                    this.myNewBlock = false;
                }
            }

            public void visitInsn(int opcode) {
                if (opcode >= 172 && opcode <= 177 || opcode == 191) {
                    this.myNewBlock = true;
                }
            }

            public void visitJumpInsn(int opcode, Label label) {
                this.myNewBlock = true;
            }
        }, true);
        if (mask.size() == locationsSize) {
            locations.sort(Comparator.comparing(Location::codeIndex));
            ArrayList<Location> res = new ArrayList<Location>(locationsSize);
            int pos = 0;
            for (Location location : locations) {
                if (!((Boolean)mask.get(pos++)).booleanValue()) continue;
                res.add(location);
            }
            return res;
        }
        return locations;
    }
}

