/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public final class FieldData
extends DescriptorData<FieldDescriptorImpl> {
    private final ObjectReference myObjRef;
    private final Field myField;

    public FieldData(@NotNull ObjectReference objRef, @NotNull Field field) {
        this.myObjRef = objRef;
        this.myField = field;
    }

    @Override
    protected FieldDescriptorImpl createDescriptorImpl(@NotNull Project project) {
        return new FieldDescriptorImpl(project, this.myObjRef, this.myField);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FieldData)) {
            return false;
        }
        FieldData fieldData = (FieldData)object;
        return fieldData.myField == this.myField && fieldData.myObjRef.equals(this.myObjRef);
    }

    @Override
    public int hashCode() {
        return this.myObjRef.hashCode() + this.myField.hashCode();
    }

    @Override
    public DisplayKey<FieldDescriptorImpl> getDisplayKey() {
        return new SimpleDisplayKey<FieldDescriptorImpl>(this.myField);
    }
}

