/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class HotSwapManager {
    private final Map<DebuggerSession, Long> myTimeStamps = new HashMap<DebuggerSession, Long>();
    private static final String CLASS_EXTENSION = ".class";

    private long getTimeStamp(DebuggerSession session) {
        Long tStamp = this.myTimeStamps.get(session);
        return tStamp != null ? tStamp : 0L;
    }

    private void setTimeStamp(DebuggerSession session, long tStamp) {
        this.myTimeStamps.put(session, tStamp);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(@NotNull DebuggerSession session, @Nullable NotNullLazyValue<? extends List<String>> outputPaths, @NotNull HotSwapProgress progress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long timeStamp = this.getTimeStamp(session);
        HashMap<String, HotSwapFile> modifiedClasses = new HashMap<String, HotSwapFile>();
        List paths = outputPaths != null ? (List)outputPaths.getValue() : (List)ReadAction.compute(() -> JBIterable.of((Object[])OrderEnumerator.orderEntries((Project)session.getProject()).classes().getRoots()).filterMap(o -> o.isDirectory() && !o.getFileSystem().isReadOnly() ? o.getPath() : null).toList());
        for (String path : paths) {
            String rootPath = FileUtil.toCanonicalPath((String)path);
            HotSwapManager.collectModifiedClasses(new File(path), rootPath, rootPath + "/", modifiedClasses, progress, timeStamp);
        }
        return modifiedClasses;
    }

    private static boolean collectModifiedClasses(File file, String filePath, String rootPath, Map<String, HotSwapFile> container, HotSwapProgress progress, long timeStamp) {
        if (progress.isCancelled()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (HotSwapManager.collectModifiedClasses(child, filePath + "/" + child.getName(), rootPath, container, progress, timeStamp)) continue;
                return false;
            }
        } else if ((SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)filePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath, (String)CLASS_EXTENSION)) && file.lastModified() > timeStamp) {
            progress.setText(JavaDebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath}));
            String qualifiedName = filePath.substring(rootPath.length(), filePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
            container.put(qualifiedName, new HotSwapFile(file));
        }
        return true;
    }

    private static HotSwapManager getInstance(Project project) {
        return (HotSwapManager)project.getService(HotSwapManager.class);
    }

    private void reloadClasses(DebuggerSession session, Map<String, HotSwapFile> classesToReload, HotSwapProgress progress) {
        long newSwapTime = System.currentTimeMillis();
        new ReloadClassesWorker(session, progress).reloadClasses(classesToReload);
        if (progress.isCancelled()) {
            session.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(session, newSwapTime);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<? extends DebuggerSession> sessions, Map<String, Collection<String>> generatedPaths) {
        HashMap<DebuggerSession, Map<String, HotSwapFile>> result = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> sessionWithStamps = new ArrayList<Pair>();
        for (DebuggerSession debuggerSession : sessions) {
            sessionWithStamps.add(new Pair((Object)debuggerSession, (Object)HotSwapManager.getInstance(debuggerSession.getProject()).getTimeStamp(debuggerSession)));
        }
        for (Map.Entry entry : generatedPaths.entrySet()) {
            File root = new File((String)entry.getKey());
            for (String relativePath : (Collection)entry.getValue()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)relativePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)relativePath, (String)CLASS_EXTENSION))) continue;
                String qualifiedName = relativePath.substring(0, relativePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
                HotSwapFile hotswapFile = new HotSwapFile(new File(root, relativePath));
                long fileStamp = hotswapFile.file.lastModified();
                for (Pair pair2 : sessionWithStamps) {
                    DebuggerSession session = (DebuggerSession)pair2.first;
                    if (fileStamp <= (Long)pair2.second) continue;
                    result.computeIfAbsent(session, k -> new HashMap()).put(qualifiedName, hotswapFile);
                }
            }
        }
        return result;
    }

    @NotNull
    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(@NotNull List<? extends DebuggerSession> sessions, @NotNull HotSwapProgress swapProgress) {
        return HotSwapManager.scanForModifiedClasses(sessions, null, swapProgress);
    }

    @NotNull
    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(@NotNull List<? extends DebuggerSession> sessions, final @Nullable NotNullLazyValue<? extends List<String>> outputPaths, final @NotNull HotSwapProgress swapProgress) {
        THashMap modifiedClasses = new THashMap();
        MultiProcessCommand scanClassesCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(() -> scanClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            scanClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl((Map)modifiedClasses){
                final /* synthetic */ Map val$modifiedClasses;
                {
                    this.val$modifiedClasses = map2;
                }

                @Override
                protected void action() {
                    swapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> sessionClasses = HotSwapManager.getInstance(swapProgress.getProject()).scanForModifiedClasses(debuggerSession, (NotNullLazyValue<? extends List<String>>)outputPaths, swapProgress);
                    if (!sessionClasses.isEmpty()) {
                        this.val$modifiedClasses.put(debuggerSession, sessionClasses);
                    }
                }
            });
        }
        swapProgress.setTitle(JavaDebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        scanClassesCommand.run();
        if (swapProgress.isCancelled()) {
            for (DebuggerSession debuggerSession : sessions) {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
            return Collections.emptyMap();
        }
        return modifiedClasses;
    }

    public static void reloadModifiedClasses(final @NotNull Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final @NotNull HotSwapProgress reloadClassesProgress) {
        MultiProcessCommand reloadClassesCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(() -> reloadClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            reloadClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).reloadClasses(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        reloadClassesProgress.setTitle(JavaDebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        reloadClassesCommand.run();
        ActionsCollector.getInstance().record("Reload Classes", HotSwapManager.class);
    }

    public static class HotSwapDebuggerManagerListener
    implements DebuggerManagerListener {
        private final Project myProject;

        public HotSwapDebuggerManagerListener(Project project) {
            this.myProject = project;
        }

        @Override
        public void sessionCreated(DebuggerSession session) {
            HotSwapManager.getInstance(this.myProject).setTimeStamp(session, System.currentTimeMillis());
        }

        @Override
        public void sessionRemoved(DebuggerSession session) {
            HotSwapManager.getInstance(this.myProject).myTimeStamps.remove(session);
        }
    }
}

