/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.execution.runners.JvmPatchableProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDebuggerRunner
implements JvmPatchableProgramRunner<GenericDebuggerRunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        return executorId.equals("Debug") && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultDebugAction);
    }

    @NotNull
    public String getRunnerId() {
        return "Debug";
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunProfileState state = environment.getState();
        if (state == null) {
            return;
        }
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)environment.getProject());
        executionManager.executePreparationTasks(environment, state).onSuccess(__ -> executionManager.startRunProfile(environment, state, state1 -> this.doExecute(state, environment)));
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.createContentDescriptor(state, env);
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state instanceof JavaCommandLine) {
            ProcessHandler handler;
            RunContentDescriptor descriptor;
            JavaParameters parameters2 = ((JavaCommandLine)state).getJavaParameters();
            JavaProgramPatcher.runCustomPatchers((JavaParameters)parameters2, (Executor)environment.getExecutor(), (RunProfile)environment.getRunProfile());
            boolean isPollConnection = true;
            RemoteConnection connection = null;
            if (state instanceof RemoteConnectionCreator) {
                connection = ((RemoteConnectionCreator)state).createRemoteConnection(environment);
                isPollConnection = ((RemoteConnectionCreator)state).isPollConnection();
            }
            if (connection == null) {
                int transport;
                connection = new RemoteConnectionBuilder(true, transport, (transport = DebuggerSettings.getInstance().getTransport()) == 0 ? "0" : "").asyncAgent(true).project(environment.getProject()).memoryAgent(DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(parameters2);
                isPollConnection = true;
            }
            if ((descriptor = this.attachVirtualMachine(state, environment, connection, isPollConnection)) != null && (handler = descriptor.getProcessHandler()) instanceof KillableProcessHandler) {
                ((KillableProcessHandler)handler).setShouldKillProcessSoftlyWithWinP(true);
            }
            return descriptor;
        }
        if (state instanceof PatchedRunnableState) {
            RemoteConnection connection = GenericDebuggerRunner.doPatch(new JavaParameters(), environment.getRunnerSettings(), true);
            return this.attachVirtualMachine(state, environment, connection, true);
        }
        if (state instanceof RemoteState) {
            RemoteConnection connection = GenericDebuggerRunner.createRemoteDebugConnection((RemoteState)state, environment.getRunnerSettings());
            return this.attachVirtualMachine(state, environment, connection, false);
        }
        return null;
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState state, @NotNull ExecutionEnvironment env, RemoteConnection connection, boolean pollConnection) throws ExecutionException {
        return this.attachVirtualMachine(state, env, connection, pollConnection ? 30000L : 0L);
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(RunProfileState state, @NotNull ExecutionEnvironment env, RemoteConnection connection, long pollTimeout) throws ExecutionException {
        DefaultDebugEnvironment environment = new DefaultDebugEnvironment(env, state, connection, pollTimeout);
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(env.getProject()).attachVirtualMachine(environment);
        if (debuggerSession == null) {
            return null;
        }
        final DebugProcessImpl debugProcess = debuggerSession.getProcess();
        return XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                ExecutionResult executionResult = debugProcess.getExecutionResult();
                sessionImpl.addExtraActions(executionResult.getActions());
                if (executionResult instanceof DefaultExecutionResult) {
                    sessionImpl.addRestartActions(((DefaultExecutionResult)executionResult).getRestartActions());
                }
                return JavaDebugProcess.create(session, debuggerSession);
            }
        }).getRunContentDescriptor();
    }

    private static RemoteConnection createRemoteDebugConnection(RemoteState connection, RunnerSettings settings) {
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        GenericDebuggerRunnerSettings debuggerRunnerSettings = (GenericDebuggerRunnerSettings)settings;
        if (debuggerRunnerSettings != null) {
            remoteConnection.setUseSockets(debuggerRunnerSettings.getTransport() == 0);
            remoteConnection.setDebuggerAddress(debuggerRunnerSettings.getDebugPort());
        }
        return remoteConnection;
    }

    public GenericDebuggerRunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        return new GenericDebuggerRunnerSettings();
    }

    public void patch(@NotNull JavaParameters javaParameters, @Nullable RunnerSettings settings, @NotNull RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        GenericDebuggerRunner.doPatch(javaParameters, Objects.requireNonNull(settings), beforeExecution);
        JavaProgramPatcher.runCustomPatchers((JavaParameters)javaParameters, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtensionOrFail(DefaultDebugExecutor.class)), (RunProfile)runProfile);
    }

    private static RemoteConnection doPatch(@NotNull JavaParameters javaParameters, @NotNull RunnerSettings settings, boolean beforeExecution) throws ExecutionException {
        GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)settings;
        if (StringUtil.isEmpty((String)debuggerSettings.getDebugPort())) {
            debuggerSettings.setDebugPort(DebuggerUtils.getInstance().findAvailableDebugAddress(debuggerSettings.getTransport() == 0));
        }
        return new RemoteConnectionBuilder(debuggerSettings.LOCAL, debuggerSettings.getTransport(), debuggerSettings.getDebugPort()).asyncAgent(beforeExecution).memoryAgent(beforeExecution && DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(javaParameters);
    }

    public SettingsEditor<GenericDebuggerRunnerSettings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        if (configuration instanceof RunConfigurationWithRunnerSettings && ((RunConfigurationWithRunnerSettings)configuration).isSettingsNeeded()) {
            return new GenericDebuggerParametersRunnerConfigurable(configuration.getProject());
        }
        return null;
    }
}

