/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.execution.CommandLineWrapper;
import com.intellij.util.SmartList;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUtilsImpl
extends DebuggerUtilsEx {
    public static final Key<PsiType> PSI_TYPE_KEY = Key.create((String)"PSI_TYPE_KEY");
    private static final Logger LOG = Logger.getInstance(DebuggerUtilsImpl.class);

    public PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue, StackFrameContext context) throws EvaluateException {
        return DebuggerTreeNodeExpression.substituteThis((PsiElement)expressionWithThis, howToEvaluateThis, howToEvaluateThisValue);
    }

    public DebuggerContextImpl getDebuggerContext(DataContext context) {
        return DebuggerAction.getDebuggerContext(context);
    }

    public Element writeTextWithImports(TextWithImports text2) {
        Element element = new Element("TextWithImports");
        element.setAttribute("text", text2.toExternalForm());
        element.setAttribute("type", text2.getKind() == CodeFragmentKind.EXPRESSION ? "expression" : "code fragment");
        return element;
    }

    public TextWithImports readTextWithImports(Element element) {
        LOG.assertTrue("TextWithImports".equals(element.getName()));
        String text2 = element.getAttributeValue("text");
        if ("expression".equals(element.getAttributeValue("type"))) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text2);
        }
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, text2);
    }

    public void writeTextWithImports(Element root, String name2, TextWithImports value2) {
        if (value2.getKind() == CodeFragmentKind.EXPRESSION) {
            JDOMExternalizerUtil.writeField((Element)root, (String)name2, (String)value2.toExternalForm());
        } else {
            Element element = JDOMExternalizerUtil.writeOption((Element)root, (String)name2);
            XExpression expression2 = TextWithImportsImpl.toXExpression(value2);
            if (expression2 != null) {
                XmlSerializer.serializeObjectInto((Object)new XExpressionState(expression2), (Element)element);
            }
        }
    }

    public TextWithImports readTextWithImports(Element root, String name2) {
        String s = JDOMExternalizerUtil.readField((Element)root, (String)name2);
        if (s != null) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, s);
        }
        Element option = JDOMExternalizerUtil.readOption((Element)root, (String)name2);
        if (option != null) {
            XExpressionState state = new XExpressionState();
            XmlSerializer.deserializeInto((Element)option, (Object)state);
            return TextWithImportsImpl.fromXExpression(state.toXExpression());
        }
        return null;
    }

    public TextWithImports createExpressionWithImports(String expression2) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression2);
    }

    public PsiElement getContextElement(StackFrameContext context) {
        return PositionUtil.getContextElement(context);
    }

    @NotNull
    public static Pair<PsiElement, PsiType> getPsiClassAndType(@Nullable String className2, Project project) {
        PsiClass contextClass = null;
        PsiPrimitiveType contextType = null;
        if (!StringUtil.isEmpty((String)className2)) {
            PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(className2);
            if (primitiveType != null) {
                contextClass = JavaPsiFacade.getInstance((Project)project).findClass(primitiveType.getBoxedTypeName(), GlobalSearchScope.allScope((Project)project));
                contextType = primitiveType;
            } else {
                contextClass = DebuggerUtilsImpl.findClass((String)className2, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                if (contextClass != null) {
                    contextClass = contextClass.getNavigationElement();
                }
                if (contextClass instanceof PsiCompiledElement) {
                    contextClass = ((PsiCompiledElement)contextClass).getMirror();
                }
                contextType = DebuggerUtilsImpl.getType((String)className2, (Project)project);
            }
            if (contextClass != null) {
                contextClass.putUserData(PSI_TYPE_KEY, (Object)contextType);
            }
        }
        return Pair.create(contextClass, contextType);
    }

    public PsiClass chooseClassDialog(String title, Project project) {
        TreeClassChooser dialog = TreeClassChooserFactory.getInstance((Project)project).createAllProjectScopeChooser(title);
        dialog.showDialog();
        return dialog.getSelected();
    }

    public String findAvailableDebugAddress(boolean useSockets) throws ExecutionException {
        if (useSockets) {
            int freePort;
            try {
                freePort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException(DebugProcessImpl.processError(e));
            }
            return Integer.toString(freePort);
        }
        ListeningConnector connector = (ListeningConnector)DebugProcessImpl.findConnector(false, true);
        try {
            return DebuggerUtilsImpl.tryShmemConnect(connector, "");
        }
        catch (Exception e) {
            int tryNum = 0;
            while (true) {
                try {
                    return DebuggerUtilsImpl.tryShmemConnect(connector, "javadebug_" + (int)(Math.random() * 1000.0));
                }
                catch (Exception ex) {
                    if (tryNum++ <= 10) continue;
                    throw new ExecutionException(DebugProcessImpl.processError(ex));
                }
                break;
            }
        }
    }

    private static String tryShmemConnect(ListeningConnector connector, String address) throws IOException, IllegalConnectorArgumentsException {
        Map<String, Connector.Argument> map2 = connector.defaultArguments();
        map2.get("name").setValue(address);
        address = connector.startListening(map2);
        connector.stopListening(map2);
        return address;
    }

    public static boolean isRemote(DebugProcess debugProcess) {
        return Boolean.TRUE.equals(debugProcess.getUserData(BatchEvaluator.REMOTE_SESSION_KEY));
    }

    public static <T, E extends Exception> T suppressExceptions(ThrowableComputable<? extends T, ? extends E> supplier, T defaultValue) throws E {
        return DebuggerUtilsImpl.suppressExceptions(supplier, defaultValue, true, null);
    }

    public static <T, E extends Exception> T suppressExceptions(ThrowableComputable<? extends T, ? extends E> supplier, T defaultValue, boolean ignorePCE, Class<E> rethrow) throws E {
        try {
            return (T)supplier.compute();
        }
        catch (ProcessCanceledException e) {
            if (!ignorePCE) {
                throw e;
            }
        }
        catch (ObjectCollectedException | VMDisconnectedException e) {
            throw e;
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        catch (AssertionError | Exception e) {
            if (rethrow != null && rethrow.isInstance(e)) {
                throw e;
            }
            LOG.error((Throwable)e);
        }
        return defaultValue;
    }

    public static String getConnectionDisplayName(RemoteConnection connection) {
        if (connection instanceof PidRemoteConnection) {
            return "pid " + ((PidRemoteConnection)connection).getPid();
        }
        String addressDisplayName = JavaDebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
        String transportName = JavaDebuggerBundle.getTransportName((RemoteConnection)connection);
        return JavaDebuggerBundle.message((String)"string.connection", (Object[])new Object[]{addressDisplayName, transportName});
    }

    public static boolean instanceOf(@Nullable ReferenceType type2, @NotNull ReferenceType superType) {
        if (type2 == null) {
            return false;
        }
        if (superType.equals(type2) || "java.lang.Object".equals(superType.name())) {
            return true;
        }
        return DebuggerUtilsImpl.supertypes(type2).anyMatch(t -> DebuggerUtilsImpl.instanceOf(t, superType));
    }

    public static Stream<? extends ReferenceType> supertypes(ReferenceType type2) {
        if (type2 instanceof InterfaceType) {
            return ((InterfaceType)type2).superinterfaces().stream();
        }
        if (type2 instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type2).superclass()).prepend(((ClassType)type2).interfaces());
        }
        return StreamEx.empty();
    }

    public static byte @Nullable [] readBytesArray(Value bytesArray) {
        if (bytesArray instanceof ArrayReference) {
            List<Value> values = ((ArrayReference)bytesArray).getValues();
            byte[] res = new byte[values.size()];
            int idx = 0;
            for (Value value2 : values) {
                if (value2 instanceof ByteValue) {
                    res[idx++] = ((ByteValue)value2).value();
                    continue;
                }
                return null;
            }
            return res;
        }
        return null;
    }

    protected Location getLocation(SuspendContext context) {
        return ((SuspendContextImpl)context).getLocation();
    }

    @NotNull
    public static String getIdeaRtPath() {
        if (PluginManagerCore.isRunningFromSources()) {
            Class<CommandLineWrapper> aClass = CommandLineWrapper.class;
            try {
                String resourcePath = aClass.getName().replace('.', '/') + ".class";
                Enumeration<URL> urls = aClass.getClassLoader().getResources(resourcePath);
                while (urls.hasMoreElements()) {
                    String testResourcePath;
                    String path;
                    String testPath;
                    URL url = urls.nextElement();
                    if (!url.getProtocol().equals("file") || !StringUtilRt.endsWithIgnoreCase((CharSequence)(testPath = (path = URLUtil.urlToFile((URL)url).getPath()).replace('\\', '/')), (CharSequence)(testResourcePath = resourcePath.replace('\\', '/')))) continue;
                    return path.substring(0, path.length() - resourcePath.length() - 1);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return JavaSdkUtil.getIdeaRtJarPath();
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        int chunkSize;
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        int total = list.size();
        for (int loaded = 0; loaded < total; loaded += chunkSize) {
            chunkSize = Math.min(size, total - loaded);
            res.add(list.subList(loaded, loaded + chunkSize));
        }
        return res;
    }

    @NotNull
    public static CompletableFuture<List<NodeRenderer>> getApplicableRenderers(List<NodeRenderer> renderers, Type type2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CompletableFuture[] futures = (CompletableFuture[])renderers.stream().map(r -> r.isApplicableAsync(type2)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(__ -> {
            SmartList res = new SmartList();
            for (int i = 0; i < futures.length; ++i) {
                try {
                    if (!((Boolean)futures[i].join()).booleanValue()) continue;
                    res.add(renderers.get(i));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
            return res;
        });
    }
}

