/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuspendContextCommandImpl
extends DebuggerCommandImpl {
    private static final Logger LOG = Logger.getInstance(SuspendContextCommand.class);
    private final SuspendContextImpl mySuspendContext;

    protected SuspendContextCommandImpl(@Nullable SuspendContextImpl suspendContext) {
        this.mySuspendContext = suspendContext;
    }

    @Deprecated
    public void contextAction() throws Exception {
        throw new AbstractMethodError();
    }

    public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
        this.contextAction();
    }

    @Override
    public final void action() throws Exception {
        SuspendContextImpl suspendContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying " + this);
        }
        if ((suspendContext = this.getSuspendContext()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip processing - context is null " + this);
            }
            this.notifyCancelled();
            return;
        }
        if (suspendContext.myInProgress) {
            suspendContext.postponeCommand(this);
        } else {
            try {
                if (!suspendContext.isResumed()) {
                    suspendContext.myInProgress = true;
                    this.contextAction(suspendContext);
                } else {
                    this.notifyCancelled();
                }
            }
            finally {
                suspendContext.myInProgress = false;
                if (suspendContext.isResumed()) {
                    SuspendContextCommandImpl postponed = suspendContext.pollPostponedCommand();
                    while (postponed != null) {
                        postponed.notifyCancelled();
                        postponed = suspendContext.pollPostponedCommand();
                    }
                } else {
                    SuspendContextCommandImpl postponed = suspendContext.pollPostponedCommand();
                    if (postponed != null) {
                        suspendContext.getDebugProcess().getManagerThread().pushBack(postponed);
                    }
                }
            }
        }
    }

    @Nullable
    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }
}

