/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.CaptureTraverser;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

public class ThisEvaluator
implements Evaluator {
    private final CaptureTraverser myTraverser;

    public ThisEvaluator() {
        this(CaptureTraverser.direct());
    }

    public ThisEvaluator(CaptureTraverser traverser) {
        this.myTraverser = traverser;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value objRef = context.computeThisObject();
        if (objRef instanceof ObjectReference) {
            objRef = this.myTraverser.traverse((ObjectReference)objRef);
        }
        if (objRef == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.this.not.avalilable", (Object[])new Object[0]));
        }
        return objRef;
    }

    public String toString() {
        return "this";
    }
}

