/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;

public class BoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;

    public BoxingEvaluator(Evaluator operand2) {
        this.myOperand = DisableGC.create(operand2);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return BoxingEvaluator.box(this.myOperand.evaluate(context), context);
    }

    public static Object box(Object value2, EvaluationContextImpl context) throws EvaluateException {
        PrimitiveValue primitiveValue;
        PsiPrimitiveType primitiveType;
        if (value2 instanceof PrimitiveValue && (primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((primitiveValue = (PrimitiveValue)value2).type().name())) != null) {
            return BoxingEvaluator.convertToWrapper(context, primitiveValue, primitiveType.getBoxedTypeName());
        }
        return value2;
    }

    private static Value convertToWrapper(EvaluationContextImpl context, PrimitiveValue value2, String wrapperTypeName) throws EvaluateException {
        String methodSignature;
        DebugProcessImpl process2 = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)process2.findClass(context, wrapperTypeName, null);
        Method method = DebuggerUtils.findMethod((ReferenceType)wrapperClass, (String)"valueOf", (String)(methodSignature = "(" + JVMNameUtil.getPrimitiveSignature(value2.type().name()) + ")L" + wrapperTypeName.replace('.', '/') + ";"));
        if (method == null) {
            method = DebuggerUtils.findMethod((ReferenceType)wrapperClass, (String)"<init>", (String)methodSignature);
        }
        if (method == null) {
            throw new EvaluateException("Cannot construct wrapper object for value of type " + value2.type() + ": Unable to find either valueOf() or constructor method");
        }
        Method finalMethod = method;
        List<PrimitiveValue> args = Collections.singletonList(value2);
        return context.computeAndKeep(() -> process2.invokeMethod((EvaluationContext)context, wrapperClass, finalMethod, (List<? extends Value>)args));
    }
}

