/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;
    private static final char SEPARATOR = '\r';

    public TextWithImportsImpl(@NotNull PsiElement expression2) {
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text2 = expression2.getText();
        PsiFile containingFile = expression2.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text2;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = JavaFileType.INSTANCE;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text2);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind2, @NotNull String text2, @NotNull String imports2, @Nullable FileType fileType) {
        this.myKind = kind2;
        this.myText = text2;
        this.myImports = imports2;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind2, @NotNull String text2) {
        this.myKind = kind2;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text2);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        return this.myImports;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Objects.equals(item.myText, this.myText) && Objects.equals(item.myImports, this.myImports);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String result = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result = result + '\r' + this.myImports;
        }
        if (this.myFileType != null) {
            result = result + '\r' + this.myFileType.getName();
        }
        return result;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports text2) {
        if (text2 != null && !text2.getText().isEmpty()) {
            return new XExpressionImpl(text2.getText(), LanguageUtil.getFileTypeLanguage((FileType)text2.getFileType()), StringUtil.nullize((String)text2.getImports()), TextWithImportsImpl.getMode(text2.getKind()));
        }
        return null;
    }

    @NotNull
    private static EvaluationMode getMode(@NotNull CodeFragmentKind kind2) {
        switch (kind2) {
            case EXPRESSION: {
                return EvaluationMode.EXPRESSION;
            }
            case CODE_BLOCK: {
                return EvaluationMode.CODE_FRAGMENT;
            }
        }
        throw new IllegalStateException("Unknown kind " + kind2);
    }

    @NotNull
    private static CodeFragmentKind getKind(@NotNull EvaluationMode mode) {
        switch (mode) {
            case EXPRESSION: {
                return CodeFragmentKind.EXPRESSION;
            }
            case CODE_FRAGMENT: {
                return CodeFragmentKind.CODE_BLOCK;
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public static TextWithImports fromXExpression(@Nullable XExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2.getCustomInfo() == null && expression2.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression2.getMode()), expression2.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression2.getMode()), expression2.getExpression(), StringUtil.notNullize((String)expression2.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)expression2.getLanguage()));
    }
}

