/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import org.jetbrains.annotations.NotNull;

enum DfaHint {
    NONE(null),
    ANY_VALUE(null, true),
    TRUE("= true", true),
    FALSE("= false", true),
    NPE("[NullPointerException]"),
    NULL_AS_NOT_NULL("[Null passed where not-null expected]"),
    CCE("[ClassCastException]"),
    ASE("[ArrayStoreException]"),
    AIOOBE("[ArrayIndexOutOfBoundsException]"),
    FAIL("[Method will fail]", true);

    private final String myTitle;
    private final boolean myValue;

    private DfaHint(String title) {
        this(title, false);
    }

    private DfaHint(String title, boolean value2) {
        this.myTitle = title;
        this.myValue = value2;
    }

    String getTitle() {
        return this.myTitle;
    }

    @NotNull
    DfaHint merge(@NotNull DfaHint other) {
        if (other == this) {
            return this;
        }
        if (this.myValue && other.myValue) {
            return ANY_VALUE;
        }
        if (this.myValue) {
            return other;
        }
        if (other.myValue) {
            return this;
        }
        return NONE;
    }
}

