/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemoteDebugProcessHandler
extends ProcessHandler {
    private final Project myProject;
    private final boolean myAutoRestart;
    private final AtomicBoolean myClosedByUser = new AtomicBoolean();

    public RemoteDebugProcessHandler(Project project) {
        this(project, false);
    }

    public RemoteDebugProcessHandler(Project project, boolean autoRestart) {
        this.myProject = project;
        this.myAutoRestart = autoRestart;
    }

    public void startNotify() {
        DebugProcessAdapterImpl listener = new DebugProcessAdapterImpl(){

            @Override
            public void processDetached(DebugProcessImpl process2, boolean closedByUser) {
                if (!RemoteDebugProcessHandler.this.myAutoRestart || closedByUser || RemoteDebugProcessHandler.this.myClosedByUser.get()) {
                    process2.removeDebugProcessListener(this);
                    RemoteDebugProcessHandler.this.notifyProcessDetached();
                } else {
                    process2.reattach(process2.getSession().getDebugEnvironment());
                }
            }
        };
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        debugProcess.addDebugProcessListener((DebugProcessListener)listener);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess.isDetached()) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)listener);
                this.notifyProcessDetached();
            }
        }
    }

    protected void destroyProcessImpl() {
        this.myClosedByUser.set(true);
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(true);
        }
    }

    protected void detachProcessImpl() {
        this.myClosedByUser.set(true);
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(false);
        }
    }

    public boolean detachIsDefault() {
        return true;
    }

    public OutputStream getProcessInput() {
        return null;
    }
}

