/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.FieldReferringObject;
import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.SimpleReferringObject;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ReferringObjectsProvider {
    public static final ReferringObjectsProvider BASIC_JDI = new ReferringObjectsProvider(){

        @Override
        @NotNull
        public List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value2, long limit) {
            return ContainerUtil.map(value2.referringObjects(limit), x -> this.asReferringObject((ObjectReference)x, value2));
        }

        private ReferringObject asReferringObject(@NotNull ObjectReference referrer, @NotNull ObjectReference referee) {
            Field field = this.findField(referee, referrer);
            if (field != null) {
                return new FieldReferringObject(referrer, field);
            }
            return new SimpleReferringObject(referrer);
        }

        @Nullable
        private Field findField(@NotNull Value value2, @NotNull ObjectReference reference) {
            for (Field field : reference.referenceType().allFields()) {
                if (reference.getValue(field) != value2) continue;
                return field;
            }
            return null;
        }
    };

    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, long var3) throws EvaluateException;
}

