/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReferringObject
implements ReferringObject {
    @NotNull
    private final ObjectReference myReference;
    @NotNull
    private final Field myField;

    public FieldReferringObject(@NotNull ObjectReference reference, @NotNull Field field) {
        this.myReference = reference;
        this.myField = field;
    }

    @Override
    @NotNull
    public ValueDescriptorImpl createValueDescription(@NotNull Project project, @NotNull Value referee) {
        return new FieldDescriptorImpl(project, this.myReference, this.myField){

            @Override
            public Value calcValue(EvaluationContextImpl evaluationContext) {
                return FieldReferringObject.this.myReference;
            }
        };
    }

    @Override
    @Nullable
    public String getNodeName(int order) {
        return null;
    }

    @Override
    @NotNull
    public Function<XValueNode, XValueNode> getNodeCustomizer() {
        return node -> new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl((XValueNode)node){
            final /* synthetic */ XValueNode val$node;
            {
                this.val$node = xValueNode;
            }

            public void applyPresentation(@Nullable Icon icon, final @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                this.val$node.setPresentation(icon, new XValuePresentation(){

                    @NotNull
                    public String getSeparator() {
                        return " in ";
                    }

                    @Nullable
                    public String getType() {
                        return valuePresenter.getType();
                    }

                    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                        valuePresenter.renderValue(renderer);
                    }
                }, hasChildren);
            }

            public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
            }
        };
    }
}

