/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeTypeEvaluator
extends EditorEvaluationCommand<PsiType> {
    public RuntimeTypeEvaluator(@Nullable Editor editor, PsiElement expression2, DebuggerContextImpl context, ProgressIndicator indicator) {
        super(editor, expression2, context, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadAction(@NotNull SuspendContextImpl suspendContext) {
        PsiType type2 = null;
        try {
            type2 = (PsiType)this.evaluate();
        }
        catch (EvaluateException | ProcessCanceledException throwable) {
        }
        finally {
            this.typeCalculationFinished(type2);
        }
    }

    protected abstract void typeCalculationFinished(@Nullable PsiType var1);

    @Override
    @Nullable
    protected PsiType evaluate(EvaluationContextImpl evaluationContext) throws EvaluateException {
        SourcePosition position;
        Project project = evaluationContext.getProject();
        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project, new EvaluatingComputable<ExpressionEvaluator>(position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext)){
            final /* synthetic */ SourcePosition val$position;
            {
                this.val$position = sourcePosition;
            }

            @Override
            public ExpressionEvaluator compute() throws EvaluateException {
                return EvaluatorBuilderImpl.getInstance().build(RuntimeTypeEvaluator.this.myElement, this.val$position);
            }
        });
        Value value2 = evaluator.evaluate((EvaluationContext)evaluationContext);
        if (value2 != null) {
            return RuntimeTypeEvaluator.getCastableRuntimeType(project, value2);
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.surrounded.expression.null", (Object[])new Object[0]));
    }

    @Nullable
    public static PsiType getCastableRuntimeType(Project project, Value value2) {
        Type type2 = value2.type();
        PsiType psiType = RuntimeTypeEvaluator.findPsiType(project, type2);
        if (psiType != null) {
            return psiType;
        }
        if (type2 instanceof ClassType) {
            ClassType superclass = ((ClassType)type2).superclass();
            if (superclass != null && !"java.lang.Object".equals(superclass.name()) && (psiType = RuntimeTypeEvaluator.findPsiType(project, superclass)) != null) {
                return psiType;
            }
            for (InterfaceType interfaceType : ((ClassType)type2).interfaces()) {
                psiType = RuntimeTypeEvaluator.findPsiType(project, interfaceType);
                if (psiType == null) continue;
                return psiType;
            }
        }
        return null;
    }

    private static PsiType findPsiType(Project project, Type type2) {
        return (PsiType)ReadAction.compute(() -> DebuggerUtils.getType((String)type2.name().replace('$', '.'), (Project)project));
    }

    public static boolean isSubtypeable(PsiExpression expr2) {
        PsiClass psiClass;
        PsiType type2 = expr2.getType();
        if (type2 instanceof PsiPrimitiveType) {
            return false;
        }
        return !(type2 instanceof PsiClassType) || (psiClass = ((PsiClassType)type2).resolve()) == null || !psiClass.hasModifierProperty("final");
    }
}

