/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class JavaWithRuntimeCastSurrounder
extends JavaExpressionSurrounder {
    public String getTemplateDescription() {
        return JavaDebuggerBundle.message((String)"surround.with.runtime.type.template", (Object[])new Object[0]);
    }

    public boolean isApplicable(PsiExpression expr2) {
        if (!expr2.isPhysical()) {
            return false;
        }
        PsiFile file = expr2.getContainingFile();
        if (!(file instanceof PsiCodeFragment)) {
            return false;
        }
        if (!DefaultCodeFragmentFactory.isDebuggerFile(file)) {
            return false;
        }
        return RuntimeTypeEvaluator.isSubtypeable(expr2);
    }

    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr2) throws IncorrectOperationException {
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession != null) {
            ProgressWindow progressWindow = new ProgressWindow(true, expr2.getProject());
            SurroundWithCastWorker worker = new SurroundWithCastWorker(editor, expr2, debuggerContext, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(JavaDebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            debuggerContext.getDebugProcess().getManagerThread().startProgress(worker, progressWindow);
        }
        return null;
    }

    private static class SurroundWithCastWorker
    extends RuntimeTypeEvaluator {
        private final Editor myEditor;

        SurroundWithCastWorker(Editor editor, PsiExpression expression2, DebuggerContextImpl context, ProgressIndicator indicator) {
            super(editor, (PsiElement)expression2, context, indicator);
            this.myEditor = editor;
        }

        @Override
        protected void typeCalculationFinished(@Nullable PsiType type2) {
            if (type2 == null) {
                return;
            }
            this.hold();
            Project project = this.myElement.getProject();
            DebuggerInvocationUtil.invokeLater(project, () -> WriteCommandAction.writeCommandAction((Project)project).withName(JavaDebuggerBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0])).run(() -> {
                try {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myElement.getProject());
                    PsiParenthesizedExpression parenth = (PsiParenthesizedExpression)factory.createExpressionFromText("((" + type2.getCanonicalText() + ")expr)", null);
                    ((PsiTypeCastExpression)parenth.getExpression()).getOperand().replace(this.myElement);
                    parenth = (PsiParenthesizedExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)parenth);
                    PsiExpression expr2 = (PsiExpression)this.myElement.replace((PsiElement)parenth);
                    TextRange range = expr2.getTextRange();
                    this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                    this.myEditor.getCaretModel().moveToOffset(range.getEndOffset());
                    this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                }
                finally {
                    this.release();
                }
            }), this.myProgressIndicator.getModalityState());
        }
    }
}

