/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.NotNull;

public class ResumeThreadAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNode = ResumeThreadAction.getSelectedNodes(e.getDataContext());
        DebuggerContextImpl debuggerContext = ResumeThreadAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        for (final DebuggerTreeNodeImpl debuggerTreeNode : selectedNode) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)debuggerTreeNode.getDescriptor();
            if (!threadDescriptor.isSuspended()) continue;
            final ThreadReferenceProxyImpl thread = threadDescriptor.getThreadReference();
            debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendingContext = SuspendManagerUtil.getSuspendingContext(debugProcess.getSuspendManager(), thread);
                    if (suspendingContext != null) {
                        debugProcess.createResumeThreadCommand(suspendingContext, thread).run();
                    }
                    debuggerTreeNode.calcValue();
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNodes = ResumeThreadAction.getSelectedNodes(e.getDataContext());
        boolean visible = false;
        boolean enabled = false;
        String text2 = JavaDebuggerBundle.message((String)"action.resume.thread.text.resume", (Object[])new Object[0]);
        if (selectedNodes != null && selectedNodes.length > 0) {
            visible = true;
            enabled = true;
            for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                NodeDescriptorImpl threadDescriptor = selectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                visible = false;
                break;
            }
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(text2);
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
    }
}

