/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JvmSmartStepIntoActionHandler
extends XSmartStepIntoHandler<JvmSmartStepIntoVariant> {
    private final DebuggerSession mySession;

    public JvmSmartStepIntoActionHandler(@NotNull DebuggerSession session) {
        this.mySession = session;
    }

    @NotNull
    public Promise<List<JvmSmartStepIntoVariant>> computeSmartStepVariantsAsync(@NotNull XSourcePosition position) {
        return this.findVariants(position, true);
    }

    @NotNull
    public Promise<List<JvmSmartStepIntoVariant>> computeStepIntoVariants(@NotNull XSourcePosition position) {
        return this.findVariants(position, false);
    }

    private Promise<List<JvmSmartStepIntoVariant>> findVariants(@NotNull XSourcePosition xPosition, boolean smart) {
        SourcePosition position = DebuggerUtilsEx.toSourcePosition(xPosition, this.mySession.getProject());
        for (JvmSmartStepIntoHandler handler : JvmSmartStepIntoHandler.EP_NAME.getExtensionList()) {
            if (!handler.isAvailable(position)) continue;
            Promise<List<SmartStepTarget>> targets = smart ? handler.findSmartStepTargetsAsync(position, this.mySession) : handler.findStepIntoTargets(position, this.mySession);
            return targets.then(results -> ContainerUtil.map((Collection)results, target -> new JvmSmartStepIntoVariant((SmartStepTarget)target, handler)));
        }
        return Promises.rejectedPromise();
    }

    @NotNull
    public List<JvmSmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        throw new IllegalStateException("Should not be called");
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        return JavaDebuggerBundle.message((String)"title.smart.step.popup", (Object[])new Object[0]);
    }

    public void stepIntoEmpty(XDebugSession session) {
        session.forceStepInto();
    }

    public void startStepInto(@NotNull JvmSmartStepIntoVariant variant, @Nullable XSuspendContext context) {
        this.mySession.stepInto(true, variant.myHandler.createMethodFilter(variant.myTarget));
    }

    static class JvmSmartStepIntoVariant
    extends XSmartStepIntoVariant {
        private final SmartStepTarget myTarget;
        private final JvmSmartStepIntoHandler myHandler;

        JvmSmartStepIntoVariant(SmartStepTarget target, JvmSmartStepIntoHandler handler) {
            this.myTarget = target;
            this.myHandler = handler;
        }

        public String getText() {
            return this.myTarget.getPresentation();
        }

        @Nullable
        public Icon getIcon() {
            return this.myTarget.getIcon();
        }

        @Nullable
        public TextRange getHighlightRange() {
            PsiElement element = this.myTarget.getHighlightElement();
            return element != null ? element.getTextRange() : null;
        }
    }
}

