/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.settings.JavaDebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CustomizeContextViewAction
extends XDebuggerTreeActionBase {
    private static int ourLastSelectedTabIndex = 0;

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.perform(null, "", e);
    }

    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project project = e.getProject();
        final MyTabbedConfigurable configurable = new MyTabbedConfigurable();
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable){

            protected void doOKAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doOKAction();
            }

            public void doCancelAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doCancelAction();
            }
        };
        editor.show();
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setText(ActionsBundle.actionText((String)"Debugger.CustomizeContextView"));
        e.getPresentation().setEnabledAndVisible(DebuggerAction.isInJavaSession(e));
    }

    private static class MyTabbedConfigurable
    extends TabbedConfigurable {
        private MyTabbedConfigurable() {
        }

        @NotNull
        protected List<Configurable> createConfigurables() {
            return JavaDebuggerSettings.createDataViewsConfigurable();
        }

        public void apply() throws ConfigurationException {
            super.apply();
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }

        public String getDisplayName() {
            return JavaDebuggerBundle.message((String)"title.customize.data.views", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            return "reference.debug.customize.data.view";
        }

        protected void createConfigurableTabs() {
            for (Configurable configurable : this.getConfigurables()) {
                JComponent component = configurable.createComponent();
                assert (component != null);
                component.setBorder((Border)JBUI.Borders.empty((int)8, (int)8));
                this.myTabbedPane.addTab(configurable.getDisplayName(), component);
            }
            this.myTabbedPane.setSelectedIndex(ourLastSelectedTabIndex);
        }

        int getSelectedIndex() {
            return this.myTabbedPane.getSelectedIndex();
        }
    }
}

