/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDebugEnvironment
implements DebugEnvironment {
    private final GlobalSearchScope mySearchScope;
    private final RemoteConnection myRemoteConnection;
    private final long myPollTimeout;
    private final ExecutionEnvironment environment;
    private final RunProfileState state;
    private final boolean myNeedParametersSet;
    public static final KeyWithDefaultValue<Integer> DEBUGGER_TRACE_MODE = KeyWithDefaultValue.create((String)"DEBUGGER_TRACE_MODE", (Object)0);

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) {
        this(environment, state, remoteConnection, pollConnection ? 30000L : 0L);
    }

    public DefaultDebugEnvironment(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, RemoteConnection remoteConnection, long pollTimeout) {
        this.environment = environment;
        this.state = state;
        this.myRemoteConnection = remoteConnection;
        this.myPollTimeout = pollTimeout;
        this.mySearchScope = DefaultDebugEnvironment.createSearchScope(environment.getProject(), environment.getRunProfile());
        this.myNeedParametersSet = remoteConnection.isServerMode() && remoteConnection.isUseSockets() && "0".equals(remoteConnection.getApplicationAddress());
    }

    private static GlobalSearchScope createSearchScope(final @NotNull Project project, @Nullable RunProfile runProfile) {
        GlobalSearchScope scope = GlobalSearchScopes.executionScope((Project)project, (RunProfile)runProfile);
        if (scope.equals(GlobalSearchScope.allScope((Project)project))) {
            return new DelegatingGlobalSearchScope(scope){
                final ProjectFileIndex myProjectFileIndex;
                final Comparator<VirtualFile> myScopeComparator;
                {
                    super(x0);
                    this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    this.myScopeComparator = Comparator.comparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInSourceContent(arg_0)).thenComparing(arg_0 -> ((ProjectFileIndex)this.myProjectFileIndex).isInLibrarySource(arg_0)).thenComparing((x$0, x$1) -> super.compare(x$0, x$1));
                }

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    return this.myScopeComparator.compare(file1, file2);
                }
            };
        }
        return scope;
    }

    @Override
    public ExecutionResult createExecutionResult() throws ExecutionException {
        if (this.myNeedParametersSet && this.state instanceof JavaCommandLine) {
            new RemoteConnectionBuilder(true, 0, this.myRemoteConnection.getApplicationAddress()).create(((JavaCommandLine)this.state).getJavaParameters());
        }
        return this.state.execute(this.environment.getExecutor(), this.environment.getRunner());
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Override
    public boolean isRemote() {
        return this.state instanceof RemoteState;
    }

    @Override
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    @Override
    public long getPollTimeout() {
        return this.myPollTimeout;
    }

    @Override
    public String getSessionName() {
        return this.environment.getRunProfile().getName();
    }

    @Override
    @Nullable
    public Sdk getAlternativeJre() {
        return AlternativeJreClassFinder.getAlternativeJre(this.environment.getRunProfile());
    }

    @Override
    @Nullable
    public Sdk getRunJre() {
        if (this.state instanceof JavaCommandLine) {
            try {
                return ((JavaCommandLine)this.state).getJavaParameters().getJdk();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return ProjectRootManager.getInstance((Project)this.environment.getProject()).getProjectSdk();
    }

    public int getTraceMode() {
        return (Integer)this.environment.getUserData(DEBUGGER_TRACE_MODE);
    }
}

