/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import io.netty.channel.Channel;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public abstract class DefaultMessageHandler
implements BuilderMessageHandler {
    private static final Logger LOG = Logger.getInstance(DefaultMessageHandler.class);
    private final Project myProject;

    protected DefaultMessageHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void buildStarted(@NotNull UUID sessionId) {
    }

    @Override
    public final void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
        switch (msg.getType()) {
            case BUILD_EVENT: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event = msg.getBuildEvent();
                if (event.getEventType() == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.CUSTOM_BUILDER_MESSAGE && event.hasCustomBuilderMessage()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message2 = event.getCustomBuilderMessage();
                    if (!this.myProject.isDisposed()) {
                        ((CustomBuilderMessageHandler)this.myProject.getMessageBus().syncPublisher(CustomBuilderMessageHandler.TOPIC)).messageReceived(message2.getBuilderId(), message2.getMessageType(), message2.getMessageText());
                    }
                }
                this.handleBuildEvent(sessionId, event);
                break;
            }
            case COMPILE_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage = msg.getCompileMessage();
                this.handleCompileMessage(sessionId, compileMessage);
                if (compileMessage.getKind() != CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INTERNAL_BUILDER_ERROR) break;
                LOG.error("Internal build error:\n" + compileMessage.getText());
                break;
            }
        }
    }

    protected abstract void handleCompileMessage(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage var2);

    protected abstract void handleBuildEvent(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent var2);
}

