/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.java.compiler.JpsValidationSerializer;

@State(name="ValidationConfiguration", storages={@Storage(value="validation.xml")})
public class ValidationConfiguration
implements PersistentStateComponent<JpsValidationSerializer.ValidationConfigurationState> {
    private final JpsValidationSerializer.ValidationConfigurationState myState = new JpsValidationSerializer.ValidationConfigurationState();
    private final Project myProject;

    public ValidationConfiguration(Project project) {
        this.myProject = project;
    }

    public static boolean shouldValidate(Validator validator2, Project project) {
        ValidationConfiguration configuration = ValidationConfiguration.getInstance(project);
        return configuration.myState.VALIDATE_ON_BUILD && configuration.isSelected(validator2);
    }

    public boolean isSelected(Validator validator2) {
        return this.isSelected(validator2.getId());
    }

    public boolean isSelected(String validatorId) {
        Boolean selected = (Boolean)this.myState.VALIDATORS.get(validatorId);
        return selected == null || selected != false;
    }

    public boolean isValidateOnBuild() {
        return this.myState.VALIDATE_ON_BUILD;
    }

    public void setValidateOnBuild(boolean value2) {
        this.myState.VALIDATE_ON_BUILD = value2;
    }

    public void setSelected(Validator validator2, boolean selected) {
        this.setSelected(validator2.getId(), selected);
    }

    public void deselectAllValidators() {
        for (Validator validator2 : (Validator[])CompilerManager.getInstance((Project)this.myProject).getCompilers(Validator.class)) {
            this.myState.VALIDATORS.put(validator2.getId(), false);
        }
    }

    public void setSelected(String validatorId, boolean selected) {
        this.myState.VALIDATORS.put(validatorId, selected);
    }

    public static ValidationConfiguration getInstance(Project project) {
        return (ValidationConfiguration)ServiceManager.getService((Project)project, ValidationConfiguration.class);
    }

    public static ExcludesConfiguration getExcludedEntriesConfiguration(Project project) {
        return (ExcludesConfiguration)ServiceManager.getService((Project)project, ExcludedFromValidationConfiguration.class);
    }

    @NotNull
    public JpsValidationSerializer.ValidationConfigurationState getState() {
        return this.myState;
    }

    public void loadState(@NotNull JpsValidationSerializer.ValidationConfigurationState state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    @State(name="ExcludeFromValidation", storages={@Storage(value="excludeFromValidation.xml")})
    public static class ExcludedFromValidationConfiguration
    extends ExcludedEntriesConfiguration {
        public ExcludedFromValidationConfiguration() {
            super(null);
        }
    }
}

