/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.build.FileNavigatable;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludeFromValidationAction
extends AnAction {
    public ExcludeFromValidationAction() {
        super(JavaCompilerBundle.messagePointer((String)"action.name.exclude.from.validation", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Pair<ExcludesConfiguration, VirtualFile> pair2 = ExcludeFromValidationAction.getExcludedConfigurationAndFile(e, project);
        if (pair2 == null) {
            return;
        }
        ExcludeEntryDescription description = new ExcludeEntryDescription((VirtualFile)pair2.getSecond(), false, true, (Disposable)project);
        ((ExcludesConfiguration)pair2.getFirst()).addExcludeEntryDescription(description);
    }

    @Nullable
    private static Pair<ExcludesConfiguration, VirtualFile> getExcludedConfigurationAndFile(AnActionEvent event, Project project) {
        OpenFileDescriptor fileDescriptor;
        Navigatable navigatable = (Navigatable)event.getData(CommonDataKeys.NAVIGATABLE);
        if (project == null) {
            return null;
        }
        Object file = navigatable instanceof OpenFileDescriptor ? ((OpenFileDescriptor)navigatable).getFile() : (navigatable instanceof FileNavigatable ? ((fileDescriptor = ((FileNavigatable)navigatable).getFileDescriptor()) != null ? fileDescriptor.getFile() : null) : null);
        if (file == null) {
            return null;
        }
        ExcludesConfiguration configuration = ValidationConfiguration.getExcludedEntriesConfiguration(project);
        return Pair.create((Object)configuration, (Object)file);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean applicable = ExcludeFromValidationAction.getExcludedConfigurationAndFile(e, project) != null;
        e.getPresentation().setEnabledAndVisible(applicable);
    }
}

