/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerSettingsFactory;
import com.intellij.compiler.options.CompilerUIConfigurable;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CompilerConfigurable
implements SearchableConfigurable.Parent,
Configurable.NoScroll,
Configurable.WithEpDependencies {
    private final Project myProject;
    private final CompilerUIConfigurable myCompilerUIConfigurable;
    private Configurable[] myKids;

    public CompilerConfigurable(Project project) {
        this.myProject = project;
        this.myCompilerUIConfigurable = new CompilerUIConfigurable(this.myProject);
    }

    public String getDisplayName() {
        return JavaCompilerBundle.message((String)"compiler.configurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "project.propCompiler";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    public JComponent createComponent() {
        return this.myCompilerUIConfigurable.createComponent();
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isModified() {
        return this.myCompilerUIConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myCompilerUIConfigurable.apply();
    }

    public void reset() {
        this.myCompilerUIConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myCompilerUIConfigurable.disposeUIResources();
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        return Collections.singleton(CompilerSettingsFactory.EP_NAME);
    }

    public Configurable @NotNull [] getConfigurables() {
        Configurable[] kids = this.myKids;
        if (kids == null) {
            this.myKids = kids = (Configurable[])CompilerSettingsFactory.EP_NAME.extensions((AreaInstance)this.myProject).map(f -> f.create(this.myProject)).filter(Objects::nonNull).toArray(Configurable[]::new);
        }
        return kids;
    }
}

