/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor
implements AsyncFileListener {
    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    private static void processRecursively(final @NotNull VirtualFile fromFile, final boolean dbOnly, final @NotNull FileProcessor processor2) {
        if (!(fromFile.getFileSystem() instanceof LocalFileSystem)) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                ProgressManager.checkCanceled();
                if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
                    return SKIP_CHILDREN;
                }
                if (!file.isDirectory()) {
                    processor2.execute(file);
                }
                return CONTINUE;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (dbOnly) {
                    return file.isDirectory() ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }
                if (file.equals(fromFile) || !file.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file) ? null : ((NewVirtualFile)file).iterInDbChildren();
            }
        });
    }

    private static boolean isInContentOfOpenedProject(@NotNull VirtualFile file) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isInitialized() || !BuildManager.getInstance().isProjectWatched(project) || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
            return true;
        }
        return false;
    }

    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        THashSet filesChanged = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        THashSet filesDeleted = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent) {
                TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), (Collection<? super File>)filesDeleted);
                continue;
            }
            if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
            TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), (Collection<? super File>)filesChanged);
        }
        return new AsyncFileListener.ChangeApplier((Set)filesDeleted, (Set)filesChanged){
            final /* synthetic */ Set val$filesDeleted;
            final /* synthetic */ Set val$filesChanged;
            {
                this.val$filesDeleted = set;
                this.val$filesChanged = set2;
            }

            public void afterVfsChange() {
                TranslatingCompilerFilesMonitor.after(events, this.val$filesDeleted, this.val$filesChanged);
            }
        };
    }

    private static void after(@NotNull List<? extends VFileEvent> events, Set<File> filesDeleted, Set<File> filesChanged) {
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                TranslatingCompilerFilesMonitor.handlePropChange((VFilePropertyChangeEvent)vFileEvent, filesDeleted, filesChanged);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileCopyEvent)) continue;
            TranslatingCompilerFilesMonitor.collectPaths(vFileEvent.getFile(), filesChanged);
        }
        TranslatingCompilerFilesMonitor.notifyFilesDeleted(filesDeleted);
        TranslatingCompilerFilesMonitor.notifyFilesChanged(filesChanged);
    }

    private static void handlePropChange(@NotNull VFilePropertyChangeEvent event, final @NotNull Collection<? super File> filesDeleted, @NotNull Collection<? super File> filesChanged) {
        if ("name".equals(event.getPropertyName())) {
            String newName;
            String oldName = (String)event.getOldValue();
            if (Objects.equals(oldName, newName = (String)event.getNewValue())) {
                return;
            }
            final VirtualFile eventFile = event.getFile();
            if (TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(eventFile)) {
                VirtualFile parent = eventFile.getParent();
                if (parent != null) {
                    final String root = parent.getPath() + "/" + oldName;
                    if (eventFile.isDirectory()) {
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)eventFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
                            private final StringBuilder filePath;
                            {
                                super(x0);
                                this.filePath = new StringBuilder(root);
                            }

                            public boolean visitFile(@NotNull VirtualFile child) {
                                if (child.isDirectory()) {
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        this.filePath.append("/").append(child.getName());
                                    }
                                } else {
                                    String childPath = this.filePath.toString();
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        childPath = childPath + "/" + child.getName();
                                    }
                                    filesDeleted.add(new File(childPath));
                                }
                                return true;
                            }

                            public void afterChildrenVisited(@NotNull VirtualFile file) {
                                if (file.isDirectory() && !Comparing.equal((Object)file, (Object)eventFile)) {
                                    this.filePath.delete(this.filePath.length() - file.getName().length() - 1, this.filePath.length());
                                }
                            }
                        });
                    } else {
                        filesDeleted.add(new File(root));
                    }
                }
                TranslatingCompilerFilesMonitor.collectPaths(eventFile, filesChanged);
            }
        }
    }

    private static void collectPaths(@Nullable VirtualFile file, @NotNull Collection<? super File> outFiles) {
        if (file != null && !TranslatingCompilerFilesMonitor.isIgnoredOrUnderIgnoredDirectory(file)) {
            TranslatingCompilerFilesMonitor.processRecursively(file, !TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file), f -> outFiles.add(new File(f.getPath())));
        }
    }

    private static boolean isIgnoredOrUnderIgnoredDirectory(@NotNull VirtualFile file) {
        if (TranslatingCompilerFilesMonitor.isIgnoredByBuild(file)) {
            return true;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
            if (!fileTypeManager.isFileIgnored(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredByBuild(@NotNull VirtualFile file) {
        return FileTypeManager.getInstance().isFileIgnored(file) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)file.getPath(), (boolean)false);
    }

    private static void notifyFilesChanged(@NotNull Collection<? extends File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesChanged(paths);
        }
    }

    private static void notifyFilesDeleted(@NotNull Collection<? extends File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesDeleted(paths);
        }
    }

    @FunctionalInterface
    private static interface FileProcessor {
        public void execute(@NotNull VirtualFile var1);
    }
}

