/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.ProblemsViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProblemsViewImpl
extends ProblemsView {
    private static final String PROBLEMS_TOOLWINDOW_ID = "Problems";
    private volatile ProblemsViewPanel myPanel;
    private final ExecutorService myViewUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ProblemsView Pool");

    ProblemsViewImpl(@NotNull Project project) {
        super(project);
        Disposer.register((Disposable)project, () -> this.myViewUpdater.shutdownNow());
        this.myViewUpdater.execute(() -> ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project.isDisposed()) {
                return;
            }
            ProblemsViewPanel panel2 = new ProblemsViewPanel(project);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(RegisterToolWindowTask.notClosable((String)PROBLEMS_TOOLWINDOW_ID));
            Disposer.register((Disposable)toolWindow.getDisposable(), (Disposable)panel2);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)panel2), "", false);
            content.setHelpId("reference.problems.tool.window");
            toolWindow.getContentManager().addContent(content);
            ProblemsViewImpl.doUpdateIcon(panel2, toolWindow);
            this.myPanel = panel2;
        }, ModalityState.NON_MODAL));
    }

    @Override
    public void clearOldMessages(@Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        this.myViewUpdater.execute(() -> {
            this.cleanupChildrenRecursively(this.myPanel.getErrorViewStructure().getRootElement(), scope, currentSessionId);
            this.updateIcon();
            this.myPanel.reload();
        });
    }

    private void cleanupChildrenRecursively(@NotNull Object fromElement, @Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
        for (ErrorTreeElement element : structure.getChildElements(fromElement)) {
            if (element instanceof GroupingElement) {
                VirtualFile file;
                if (scope != null && (file = ((GroupingElement)element).getFile()) != null && !scope.belongs(file.getUrl())) continue;
                if (!currentSessionId.equals(element.getData())) {
                    structure.removeElement(element);
                    continue;
                }
                this.cleanupChildrenRecursively(element, scope, currentSessionId);
                continue;
            }
            if (currentSessionId.equals(element.getData())) continue;
            structure.removeElement(element);
        }
    }

    @Override
    public void addMessage(int type2, String @NotNull [] text2, @Nullable String groupName, @Nullable Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable UUID sessionId) {
        this.myViewUpdater.execute(() -> {
            ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
            GroupingElement group = structure.lookupGroupingElement(groupName);
            if (group != null && sessionId != null && !sessionId.equals(group.getData())) {
                structure.removeElement((ErrorTreeElement)group);
            }
            if (navigatable != null) {
                this.myPanel.addMessage(type2, text2, groupName, navigatable, exportTextPrefix, rendererTextPrefix, sessionId);
            } else {
                this.myPanel.addMessage(type2, text2, null, -1, -1, sessionId);
            }
            this.updateIcon();
        });
    }

    private void updateIcon() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(PROBLEMS_TOOLWINDOW_ID);
            if (toolWindow != null) {
                ProblemsViewImpl.doUpdateIcon(this.myPanel, toolWindow);
            }
        });
    }

    private static void doUpdateIcon(@NotNull ProblemsViewPanel panel2, @NotNull ToolWindow toolWindow) {
        boolean active = panel2.getErrorViewStructure().hasMessages(EnumSet.of(ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE));
        toolWindow.setIcon(active ? AllIcons.Toolwindows.Problems : AllIcons.Toolwindows.ProblemsEmpty);
        toolWindow.setStripeTitle(IdeBundle.message((String)"toolwindow.stripe.Problems", (Object[])new Object[0]));
    }

    @Override
    public void setProgress(String text2, float fraction) {
        ProblemsViewPanel panel2 = this.myPanel;
        if (panel2 == null) {
            this.myViewUpdater.execute(() -> this.myPanel.setProgress(text2, fraction));
        } else {
            panel2.setProgress(text2, fraction);
        }
    }

    @Override
    public void setProgress(String text2) {
        ProblemsViewPanel panel2 = this.myPanel;
        if (panel2 == null) {
            this.myViewUpdater.execute(() -> this.myPanel.setProgressText(text2));
        } else {
            panel2.setProgressText(text2);
        }
    }

    @Override
    public void clearProgress() {
        ProblemsViewPanel panel2 = this.myPanel;
        if (panel2 != null) {
            panel2.clearProgressData();
        }
    }
}

