/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.impl.CompilerContentIterator;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class OneProjectItemCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private static final Logger LOG = Logger.getInstance(OneProjectItemCompileScope.class);
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myUrl;

    public OneProjectItemCompileScope(Project project, VirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        String url = file.getUrl();
        this.myUrl = file.isDirectory() ? url + "/" : url;
    }

    public VirtualFile @NotNull [] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList files = new ArrayList(1);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerContentIterator iterator = new CompilerContentIterator(fileType, (FileIndex)projectFileIndex, inSourceOnly, files);
        if (this.myFile.isDirectory()) {
            projectFileIndex.iterateContentUnderDirectory(this.myFile, (ContentIterator)iterator);
        } else {
            iterator.processFile(this.myFile);
        }
        return VfsUtilCore.toVirtualFileArray(files);
    }

    public boolean belongs(@NotNull String url) {
        if (this.myFile.isDirectory()) {
            return FileUtil.startsWith((String)url, (String)this.myUrl);
        }
        return FileUtil.pathsEqual((String)url, (String)this.myUrl);
    }

    public Module @NotNull [] getAffectedModules() {
        Collection<ModuleSourceSet> sets = this.getAffectedSourceSets();
        if (sets.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Module is null for file " + this.myFile.getPresentableUrl());
            }
            return Module.EMPTY_ARRAY;
        }
        return new Module[]{sets.iterator().next().getModule()};
    }

    public Collection<ModuleSourceSet> getAffectedSourceSets() {
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
        Module module = index.getModuleForFile(this.myFile);
        if (module == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(new ModuleSourceSet(module, index.isInTestSourceContent(this.myFile) ? ModuleSourceSet.Type.TEST : ModuleSourceSet.Type.PRODUCTION));
    }
}

